/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;

enum AwsSdkRequest {
    DynamoDbRequest(AwsSdkRequestType.DYNAMODB, "DynamoDbRequest", new FieldMapping[0]),
    S3Request(AwsSdkRequestType.S3, "S3Request", new FieldMapping[0]),
    SnsRequest(AwsSdkRequestType.SNS, "SnsRequest", new FieldMapping[0]),
    SqsRequest(AwsSdkRequestType.SQS, "SqsRequest", new FieldMapping[0]),
    KinesisRequest(AwsSdkRequestType.KINESIS, "KinesisRequest", new FieldMapping[0]),
    LambdaRequest(AwsSdkRequestType.LAMBDA, "LambdaRequest", new FieldMapping[0]),
    SecretsManagerRequest(AwsSdkRequestType.SECRETSMANAGER, "SecretsManagerRequest", new FieldMapping[0]),
    StepFunctionsRequest(AwsSdkRequestType.STEP_FUNCTIONS, "SfnRequest", new FieldMapping[0]),
    BatchGetItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.BatchGetItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "RequestItems"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity")),
    BatchWriteItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.BatchWriteItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "RequestItems"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.stringKey((String)"aws.dynamodb.item_collection_metrics"), "ItemCollectionMetrics")),
    CreateTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.CreateTableRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.global_secondary_indexes"), "GlobalSecondaryIndexes"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.local_secondary_indexes"), "LocalSecondaryIndexes"), FieldMapping.request(AttributeKey.doubleKey((String)"aws.dynamodb.provisioned_read_capacity"), "ProvisionedThroughput.ReadCapacityUnits"), FieldMapping.request(AttributeKey.doubleKey((String)"aws.dynamodb.provisioned_write_capacity"), "ProvisionedThroughput.WriteCapacityUnits"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.stringKey((String)"aws.dynamodb.item_collection_metrics"), "ItemCollectionMetrics")),
    DeleteItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.DeleteItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.stringKey((String)"aws.dynamodb.item_collection_metrics"), "ItemCollectionMetrics")),
    DeleteTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.DeleteTableRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName")),
    DescribeTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.DescribeTableRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName")),
    GetItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.GetItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.projection"), "ProjectionExpression"), FieldMapping.request(AttributeKey.booleanKey((String)"aws.dynamodb.consistent_read"), "ConsistentRead"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity")),
    ListTables(AwsSdkRequestType.DYNAMODB, "dynamodb.model.ListTablesRequest", FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.exclusive_start_table"), "ExclusiveStartTableName"), FieldMapping.response(AttributeKey.longKey((String)"aws.dynamodb.table_count"), "TableNames"), FieldMapping.request(AttributeKey.longKey((String)"aws.dynamodb.limit"), "Limit")),
    PutItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.PutItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.stringKey((String)"aws.dynamodb.item_collection_metrics"), "ItemCollectionMetrics")),
    Query(AwsSdkRequestType.DYNAMODB, "dynamodb.model.QueryRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.attributes_to_get"), "AttributesToGet"), FieldMapping.request(AttributeKey.booleanKey((String)"aws.dynamodb.consistent_read"), "ConsistentRead"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.index_name"), "IndexName"), FieldMapping.request(AttributeKey.longKey((String)"aws.dynamodb.limit"), "Limit"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.projection"), "ProjectionExpression"), FieldMapping.request(AttributeKey.booleanKey((String)"aws.dynamodb.scan_forward"), "ScanIndexForward"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.select"), "Select"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity")),
    Scan(AwsSdkRequestType.DYNAMODB, "dynamodb.model.ScanRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.attributes_to_get"), "AttributesToGet"), FieldMapping.request(AttributeKey.booleanKey((String)"aws.dynamodb.consistent_read"), "ConsistentRead"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.index_name"), "IndexName"), FieldMapping.request(AttributeKey.longKey((String)"aws.dynamodb.limit"), "Limit"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.projection"), "ProjectionExpression"), FieldMapping.request(AttributeKey.longKey((String)"aws.dynamodb.segment"), "Segment"), FieldMapping.request(AttributeKey.stringKey((String)"aws.dynamodb.select"), "Select"), FieldMapping.request(AttributeKey.longKey((String)"aws.dynamodb.total_segments"), "TotalSegments"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.longKey((String)"aws.dynamodb.count"), "Count"), FieldMapping.response(AttributeKey.longKey((String)"aws.dynamodb.scanned_count"), "ScannedCount")),
    UpdateItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.UpdateItemRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity"), FieldMapping.response(AttributeKey.stringKey((String)"aws.dynamodb.item_collection_metrics"), "ItemCollectionMetrics")),
    UpdateTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.UpdateTableRequest", FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names"), "TableName"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.attribute_definitions"), "AttributeDefinitions"), FieldMapping.request(AttributeKey.stringArrayKey((String)"aws.dynamodb.global_secondary_index_updates"), "GlobalSecondaryIndexUpdates"), FieldMapping.request(AttributeKey.doubleKey((String)"aws.dynamodb.provisioned_read_capacity"), "ProvisionedThroughput.ReadCapacityUnits"), FieldMapping.request(AttributeKey.doubleKey((String)"aws.dynamodb.provisioned_write_capacity"), "ProvisionedThroughput.WriteCapacityUnits"), FieldMapping.response(AttributeKey.stringArrayKey((String)"aws.dynamodb.consumed_capacity"), "ConsumedCapacity")),
    ConverseRequest(AwsSdkRequestType.BEDROCK_RUNTIME, "bedrockruntime.model.ConverseRequest", FieldMapping.request(AttributeKey.stringKey((String)"gen_ai.request.model"), "modelId"));

    private final AwsSdkRequestType type;
    private final String requestClass;
    private final Map<FieldMapping.Type, List<FieldMapping>> fields;

    private AwsSdkRequest(AwsSdkRequestType type, String requestClass, FieldMapping ... fields) {
        this.type = type;
        this.requestClass = requestClass;
        this.fields = Collections.unmodifiableMap(FieldMapping.groupByType(fields));
    }

    @Nullable
    static AwsSdkRequest ofSdkRequest(SdkRequest request) {
        AwsSdkRequest result = AwsSdkRequest.ofType(request.getClass().getName());
        if (result == null) {
            result = AwsSdkRequest.ofType(request.getClass().getSuperclass().getName());
        }
        return result;
    }

    private static AwsSdkRequest ofType(String typeName) {
        for (AwsSdkRequest type : AwsSdkRequest.values()) {
            if (!typeName.endsWith(type.requestClass)) continue;
            return type;
        }
        return null;
    }

    List<FieldMapping> fields(FieldMapping.Type type) {
        return this.fields.get((Object)type);
    }

    AwsSdkRequestType type() {
        return this.type;
    }
}

