/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsExperimentalAttributes;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;

enum AwsSdkRequestType {
    S3(FieldMapping.request(AttributeKeys.AWS_S3_BUCKET, "Bucket")),
    SQS(FieldMapping.request(AttributeKeys.AWS_SQS_QUEUE_URL, "QueueUrl"), FieldMapping.requestExperimental(AttributeKey.stringKey((String)"aws.queue.name"), "QueueName")),
    KINESIS(FieldMapping.request(AttributeKeys.AWS_KINESIS_STREAM_NAME, "StreamName")),
    DYNAMODB(new FieldMapping[0]),
    BEDROCK_RUNTIME(new FieldMapping[0]),
    LAMBDA(FieldMapping.requestExperimental(AwsExperimentalAttributes.AWS_LAMBDA_NAME, "FunctionName"), FieldMapping.request(AttributeKeys.access$000(), "UUID"), FieldMapping.responseExperimental(AwsExperimentalAttributes.AWS_LAMBDA_ARN, "Configuration.FunctionArn"), FieldMapping.response(AttributeKeys.access$000(), "UUID")),
    SECRETSMANAGER(FieldMapping.response(AttributeKeys.AWS_SECRETSMANAGER_SECRET_ARN, "ARN")),
    SNS(FieldMapping.request(AttributeKeys.MESSAGING_DESTINATION_NAME, "TargetArn"), FieldMapping.request(AttributeKeys.MESSAGING_DESTINATION_NAME, "TopicArn"), FieldMapping.request(AttributeKeys.AWS_SNS_TOPIC_ARN, "TopicArn"), FieldMapping.response(AttributeKeys.AWS_SNS_TOPIC_ARN, "TopicArn")),
    STEP_FUNCTIONS(FieldMapping.request(AttributeKeys.AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN, "stateMachineArn"), FieldMapping.request(AttributeKeys.AWS_STEP_FUNCTIONS_ACTIVITY_ARN, "activityArn"));

    private final Map<FieldMapping.Type, List<FieldMapping>> fields;

    private AwsSdkRequestType(FieldMapping ... fieldMappings) {
        this.fields = Collections.unmodifiableMap(FieldMapping.groupByType(fieldMappings));
    }

    List<FieldMapping> fields(FieldMapping.Type type) {
        return this.fields.get((Object)type);
    }

    private static class AttributeKeys {
        private static final AttributeKey<String> AWS_LAMBDA_RESOURCE_MAPPING_ID = AttributeKey.stringKey((String)"aws.lambda.resource_mapping.id");
        static final AttributeKey<String> AWS_SECRETSMANAGER_SECRET_ARN = AttributeKey.stringKey((String)"aws.secretsmanager.secret.arn");
        static final AttributeKey<String> AWS_SNS_TOPIC_ARN = AttributeKey.stringKey((String)"aws.sns.topic.arn");
        static final AttributeKey<String> AWS_STEP_FUNCTIONS_ACTIVITY_ARN = AttributeKey.stringKey((String)"aws.step_functions.activity.arn");
        static final AttributeKey<String> AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN = AttributeKey.stringKey((String)"aws.step_functions.state_machine.arn");
        static final AttributeKey<String> AWS_S3_BUCKET = AttributeKey.stringKey((String)"aws.s3.bucket");
        static final AttributeKey<String> AWS_SQS_QUEUE_URL = AttributeKey.stringKey((String)"aws.sqs.queue.url");
        static final AttributeKey<String> AWS_KINESIS_STREAM_NAME = AttributeKey.stringKey((String)"aws.kinesis.stream_name");
        static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey((String)"messaging.destination.name");

        private AttributeKeys() {
        }

        static /* synthetic */ AttributeKey access$000() {
            return AWS_LAMBDA_RESOURCE_MAPPING_ID;
        }
    }
}

