/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.BedrockRuntimeAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;

enum BedrockRuntimeAttributesGetter implements GenAiAttributesGetter<ExecutionAttributes, Response>
{
    INSTANCE;


    public String getOperationName(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getOperationName(executionAttributes);
    }

    public String getSystem(ExecutionAttributes executionAttributes) {
        return "aws.bedrock";
    }

    @Nullable
    public String getRequestModel(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getModelId(executionAttributes);
    }

    @Nullable
    public Long getRequestSeed(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public List<String> getRequestEncodingFormats(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Double getRequestFrequencyPenalty(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Long getRequestMaxTokens(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getMaxTokens(executionAttributes);
    }

    @Nullable
    public Double getRequestPresencePenalty(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public List<String> getRequestStopSequences(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getStopSequences(executionAttributes);
    }

    @Nullable
    public Double getRequestTemperature(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getTemperature(executionAttributes);
    }

    @Nullable
    public Double getRequestTopK(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Double getRequestTopP(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getTopP(executionAttributes);
    }

    public List<String> getResponseFinishReasons(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return Collections.emptyList();
        }
        List<String> stopReasons = BedrockRuntimeAccess.getStopReasons(executionAttributes, response);
        if (stopReasons == null) {
            return Collections.emptyList();
        }
        return stopReasons;
    }

    @Nullable
    public String getResponseId(ExecutionAttributes executionAttributes, Response response) {
        return null;
    }

    @Nullable
    public String getResponseModel(ExecutionAttributes executionAttributes, Response response) {
        return null;
    }

    @Nullable
    public Long getUsageInputTokens(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        return BedrockRuntimeAccess.getUsageInputTokens(executionAttributes, response);
    }

    @Nullable
    public Long getUsageOutputTokens(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        return BedrockRuntimeAccess.getUsageOutputTokens(executionAttributes, response);
    }

    static final class GenAiProviderNameIncubatingValues {
        static final String AWS_BEDROCK = "aws.bedrock";

        private GenAiProviderNameIncubatingValues() {
        }
    }
}

