/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapping;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.MethodHandleFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Serializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.utils.StringUtils;

class FieldMapper {
    private final Serializer serializer;
    private final MethodHandleFactory methodHandleFactory;
    private final boolean captureExperimentalSpanAttributes;

    FieldMapper(boolean captureExperimentalSpanAttributes) {
        this(new Serializer(), new MethodHandleFactory(), captureExperimentalSpanAttributes);
    }

    FieldMapper(Serializer serializer, MethodHandleFactory methodHandleFactory) {
        this(serializer, methodHandleFactory, true);
    }

    private FieldMapper(Serializer serializer, MethodHandleFactory methodHandleFactory, boolean captureExperimentalSpanAttributes) {
        this.methodHandleFactory = methodHandleFactory;
        this.serializer = serializer;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    void mapToAttributes(SdkRequest sdkRequest, AwsSdkRequest request, Span span) {
        this.mapToAttributes(field -> sdkRequest.getValueForField(field, Object.class).orElse(null), FieldMapping.Type.REQUEST, request, span);
    }

    void mapToAttributes(SdkResponse sdkResponse, AwsSdkRequest request, Span span) {
        this.mapToAttributes(field -> sdkResponse.getValueForField(field, Object.class).orElse(null), FieldMapping.Type.RESPONSE, request, span);
    }

    private void mapToAttributes(Function<String, Object> fieldValueProvider, FieldMapping.Type type, AwsSdkRequest request, Span span) {
        for (FieldMapping fieldMapping : request.fields(type)) {
            this.mapToAttributes(fieldValueProvider, fieldMapping, span);
        }
        for (FieldMapping fieldMapping : request.type().fields(type)) {
            this.mapToAttributes(fieldValueProvider, fieldMapping, span);
        }
    }

    private void mapToAttributes(Function<String, Object> fieldValueProvider, FieldMapping fieldMapping, Span span) {
        if (!this.captureExperimentalSpanAttributes && fieldMapping.isExperimental()) {
            return;
        }
        List<String> path = fieldMapping.getFields();
        Set target = fieldValueProvider.apply(path.get(0));
        for (int i = 1; i < path.size() && target != null; ++i) {
            target = this.next(target, path.get(i));
        }
        if (target != null) {
            switch (fieldMapping.getAttributeType()) {
                case STRING: {
                    String stringValue = this.serializer.serialize((Object)target);
                    if (StringUtils.isEmpty((CharSequence)stringValue)) break;
                    span.setAttribute(fieldMapping.getAttributeKey(), (Object)stringValue);
                    break;
                }
                case DOUBLE: {
                    if (!(target instanceof Number)) break;
                    span.setAttribute(fieldMapping.getAttributeKey(), (Object)((Number)((Object)target)).doubleValue());
                    break;
                }
                case LONG: {
                    if (target instanceof Number) {
                        span.setAttribute(fieldMapping.getAttributeKey(), (Object)((Number)((Object)target)).longValue());
                        break;
                    }
                    if (!(target instanceof Collection)) break;
                    span.setAttribute(fieldMapping.getAttributeKey(), ((Collection)target).size());
                    break;
                }
                case BOOLEAN: {
                    if (!(target instanceof Boolean)) break;
                    span.setAttribute(fieldMapping.getAttributeKey(), (Object)((Boolean)((Object)target)));
                    break;
                }
                case STRING_ARRAY: {
                    if (target instanceof Map) {
                        target = ((Map)((Object)target)).keySet();
                    }
                    if (target instanceof Collection) {
                        List<String> value = this.serializer.serializeCollection(target);
                        if (value.isEmpty()) break;
                        span.setAttribute(fieldMapping.getAttributeKey(), value);
                        break;
                    }
                    String value = this.serializer.serialize((Object)target);
                    if (StringUtils.isEmpty((CharSequence)value)) break;
                    span.setAttribute(fieldMapping.getAttributeKey(), Collections.singletonList(value));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported attribute type: " + fieldMapping.getAttributeType());
                }
            }
        }
    }

    @Nullable
    private Object next(Object current, String fieldName) {
        try {
            return this.methodHandleFactory.forField(current.getClass(), fieldName).invoke(current);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

