/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsJsonProtocolFactoryAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;

class Serializer {
    Serializer() {
    }

    @Nullable
    String serialize(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof SdkPojo) {
            return Serializer.serialize((SdkPojo)target);
        }
        if (target instanceof Collection) {
            return this.serialize((Collection)target);
        }
        if (target instanceof Map) {
            return Serializer.serialize(((Map)target).entrySet(), entry -> {
                String value = this.serialize(entry.getValue());
                if (value == null) {
                    value = entry.getValue() instanceof Collection || entry.getValue() instanceof Map ? "[]" : "{}";
                }
                return entry.getKey().toString() + ":" + value;
            });
        }
        return target.toString();
    }

    @Nullable
    private static String serialize(SdkPojo sdkPojo) {
        ProtocolMarshaller<SdkHttpFullRequest> marshaller = AwsJsonProtocolFactoryAccess.createMarshaller();
        if (marshaller == null) {
            return null;
        }
        Optional optional = ((SdkHttpFullRequest)marshaller.marshall(sdkPojo)).contentStreamProvider();
        return optional.map(csp -> {
            String string;
            block8: {
                InputStream cspIs = csp.newStream();
                try {
                    string = IoUtils.toUtf8String((InputStream)cspIs);
                    if (cspIs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (cspIs != null) {
                            try {
                                cspIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                cspIs.close();
            }
            return string;
        }).orElse(null);
    }

    private String serialize(Collection<?> collection) {
        return Serializer.serialize(collection, this::serialize);
    }

    private static <T> String serialize(Collection<T> collection, Function<T, String> serializer) {
        String serialized = collection.stream().map(serializer).collect(Collectors.joining(","));
        return StringUtils.isEmpty((CharSequence)serialized) ? null : "[" + serialized + "]";
    }

    List<String> serializeCollection(Collection<?> collection) {
        return collection.stream().map(this::serialize).collect(Collectors.toList());
    }
}

