/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.BedrockRuntimeAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapper;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.LambdaAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.RequestHeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SnsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingList;
import io.opentelemetry.semconv.HttpAttributes;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

public final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    private static final AttributeKey<String> AWS_REQUEST_ID = AttributeKey.stringKey((String)"aws.request_id");
    private static final ExecutionAttribute<Context> CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Context");
    private static final ExecutionAttribute<Context> PARENT_CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".ParentContext");
    private static final ExecutionAttribute<Scope> SCOPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Scope");
    private static final ExecutionAttribute<AwsSdkRequest> AWS_SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".AwsSdkRequest");
    static final ExecutionAttribute<SdkHttpRequest> SDK_HTTP_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkHttpRequest");
    static final ExecutionAttribute<SdkRequest> SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkRequest");
    private static final ExecutionAttribute<RequestSpanFinisher> REQUEST_FINISHER_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".RequestFinisher");
    static final ExecutionAttribute<TracingList> TRACING_MESSAGES_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".TracingMessages");
    private final Instrumenter<ExecutionAttributes, Response> requestInstrumenter;
    private final Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter;
    private final Instrumenter<SqsProcessRequest, Response> consumerProcessInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> producerInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> dynamoDbInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> bedrockRuntimeInstrumenter;
    private final Logger eventLogger;
    static final AttributeKey<String> HTTP_ERROR_MSG = AttributeKey.stringKey((String)"aws.http.error_message");
    static final String HTTP_FAILURE_EVENT = "HTTP request failure";
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final boolean useXrayPropagator;
    private final boolean recordIndividualHttpError;
    private final boolean genAiCaptureMessageContent;
    private final FieldMapper fieldMapper;

    Instrumenter<SqsReceiveRequest, Response> getConsumerReceiveInstrumenter() {
        return this.consumerReceiveInstrumenter;
    }

    Instrumenter<SqsProcessRequest, Response> getConsumerProcessInstrumenter() {
        return this.consumerProcessInstrumenter;
    }

    @Nullable
    TextMapPropagator getMessagingPropagator() {
        return this.messagingPropagator;
    }

    boolean shouldUseXrayPropagator() {
        return this.useXrayPropagator;
    }

    public TracingExecutionInterceptor(Instrumenter<ExecutionAttributes, Response> requestInstrumenter, Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter, Instrumenter<SqsProcessRequest, Response> consumerProcessInstrumenter, Instrumenter<ExecutionAttributes, Response> producerInstrumenter, Instrumenter<ExecutionAttributes, Response> dynamoDbInstrumenter, Instrumenter<ExecutionAttributes, Response> bedrockRuntimeInstrumenter, Logger eventLogger, boolean captureExperimentalSpanAttributes, TextMapPropagator messagingPropagator, boolean useXrayPropagator, boolean recordIndividualHttpError, boolean genAiCaptureMessageContent) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerReceiveInstrumenter = consumerReceiveInstrumenter;
        this.consumerProcessInstrumenter = consumerProcessInstrumenter;
        this.producerInstrumenter = producerInstrumenter;
        this.dynamoDbInstrumenter = dynamoDbInstrumenter;
        this.bedrockRuntimeInstrumenter = bedrockRuntimeInstrumenter;
        this.eventLogger = eventLogger;
        this.messagingPropagator = messagingPropagator;
        this.useXrayPropagator = useXrayPropagator;
        this.recordIndividualHttpError = recordIndividualHttpError;
        this.genAiCaptureMessageContent = genAiCaptureMessageContent;
        this.fieldMapper = new FieldMapper(captureExperimentalSpanAttributes);
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        RequestSpanFinisher requestFinisher;
        Context otelContext;
        Context parentOtelContext = Context.current();
        SdkRequest request = context.request();
        if (executionAttributes.getAttribute(SDK_REQUEST_ATTRIBUTE) != null) {
            return request;
        }
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION) != null) {
            return request;
        }
        executionAttributes.putAttribute(SDK_REQUEST_ATTRIBUTE, (Object)request);
        AwsSdkRequest awsSdkRequest = AwsSdkRequest.ofSdkRequest(request);
        executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, (Object)awsSdkRequest);
        Instrumenter<ExecutionAttributes, Response> instrumenter = this.getInstrumenter(request, awsSdkRequest);
        if (!instrumenter.shouldStart(parentOtelContext, (Object)executionAttributes)) {
            return request;
        }
        BedrockRuntimeAccess.maybeParseInvokeModelRequest(executionAttributes, request);
        Instant requestStart = Instant.now();
        if (Span.fromContextOrNull((Context)parentOtelContext) == null && "software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest".equals(request.getClass().getName())) {
            otelContext = InstrumenterUtil.suppressSpan(instrumenter, (Context)parentOtelContext, (Object)executionAttributes);
            requestFinisher = (finisherOtelContext, finisherExecutionAttributes, response, exception) -> {
                if (exception != null && instrumenter.shouldStart(finisherOtelContext, (Object)finisherExecutionAttributes)) {
                    InstrumenterUtil.startAndEnd((Instrumenter)instrumenter, (Context)finisherOtelContext, (Object)finisherExecutionAttributes, (Object)response, (Throwable)exception, (Instant)requestStart, (Instant)Instant.now());
                }
            };
        } else {
            otelContext = instrumenter.start(parentOtelContext, (Object)executionAttributes);
            requestFinisher = (arg_0, arg_1, arg_2, arg_3) -> instrumenter.end(arg_0, arg_1, arg_2, arg_3);
        }
        executionAttributes.putAttribute(PARENT_CONTEXT_ATTRIBUTE, (Object)parentOtelContext);
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, (Object)otelContext);
        executionAttributes.putAttribute(REQUEST_FINISHER_ATTRIBUTE, (Object)requestFinisher);
        Span span = Span.fromContext((Context)otelContext);
        try {
            if (awsSdkRequest != null) {
                executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, (Object)awsSdkRequest);
                this.fieldMapper.mapToAttributes(request, awsSdkRequest, span);
            }
        }
        catch (Throwable throwable) {
            requestFinisher.finish(otelContext, executionAttributes, null, throwable);
            TracingExecutionInterceptor.clearAttributes(executionAttributes);
            throw throwable;
        }
        SdkRequest modifiedRequest = SqsAccess.modifyRequest(request, otelContext, this.useXrayPropagator, this.messagingPropagator);
        if (modifiedRequest != null) {
            return modifiedRequest;
        }
        modifiedRequest = SnsAccess.modifyRequest(request, otelContext, this.messagingPropagator);
        if (modifiedRequest != null) {
            return modifiedRequest;
        }
        modifiedRequest = LambdaAccess.modifyRequest(request, otelContext);
        if (modifiedRequest != null) {
            return modifiedRequest;
        }
        if (BedrockRuntimeAccess.isBedrockRuntimeRequest(request)) {
            BedrockRuntimeAccess.recordRequestEvents(otelContext, this.eventLogger, executionAttributes, request, this.genAiCaptureMessageContent);
        }
        return request;
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        if (executionAttributes.getAttribute(SCOPE_ATTRIBUTE) != null) {
            return;
        }
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null && ((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            executionAttributes.putAttribute(SCOPE_ATTRIBUTE, (Object)otelContext.makeCurrent());
        }
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return;
        }
        SdkHttpRequest httpRequest = context.httpRequest();
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)httpRequest);
        TracingExecutionInterceptor.onHttpRequestAvailable(executionAttributes, otelContext, Span.fromContext((Context)otelContext));
    }

    private static void onHttpResponseAvailable(ExecutionAttributes executionAttributes, Context otelContext, Span span, SdkHttpResponse httpResponse) {
        AttributesBuilder builder = Attributes.builder();
        AwsSdkInstrumenterFactory.httpAttributesExtractor.onEnd(builder, otelContext, (Object)executionAttributes, (Object)new Response(httpResponse), null);
        span.setAllAttributes(builder.build());
    }

    private static void onHttpRequestAvailable(ExecutionAttributes executionAttributes, Context parentContext, Span span) {
        AttributesBuilder builder = Attributes.builder();
        AwsSdkInstrumenterFactory.httpAttributesExtractor.onStart(builder, parentContext, (Object)executionAttributes);
        span.setAllAttributes(builder.build());
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        if (!this.useXrayPropagator) {
            return httpRequest;
        }
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return httpRequest;
        }
        SdkHttpRequest.Builder builder = (SdkHttpRequest.Builder)httpRequest.toBuilder();
        AwsXrayPropagator.getInstance().inject(otelContext, (Object)builder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return (SdkHttpRequest)builder.build();
    }

    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        String errorMsg;
        Optional responseBody = context.responseBody();
        if (this.recordIndividualHttpError && (errorMsg = TracingExecutionInterceptor.extractHttpErrorAsEvent((Context.AfterTransmission)context, executionAttributes)) != null) {
            return Optional.of(new ByteArrayInputStream(errorMsg.getBytes(Charset.defaultCharset())));
        }
        return responseBody;
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext;
        if (executionAttributes.getAttribute(SDK_HTTP_REQUEST_ATTRIBUTE) != null) {
            Timer timer = Timer.start();
            SqsAccess.afterReceiveMessageExecution(context, executionAttributes, this, timer);
        }
        if ((otelContext = TracingExecutionInterceptor.getContext(executionAttributes)) != null) {
            BedrockRuntimeAccess.maybeParseInvokeModelResponse(executionAttributes, context.response());
            executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)context.httpRequest());
            this.onSdkResponse(otelContext, context.response(), executionAttributes);
            SdkHttpResponse httpResponse = context.httpResponse();
            TracingExecutionInterceptor.onHttpResponseAvailable(executionAttributes, otelContext, Span.fromContext((Context)otelContext), httpResponse);
            RequestSpanFinisher finisher = (RequestSpanFinisher)executionAttributes.getAttribute(REQUEST_FINISHER_ATTRIBUTE);
            finisher.finish(otelContext, executionAttributes, new Response(httpResponse, context.response(), otelContext), null);
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private void onSdkResponse(Context otelContext, SdkResponse response, ExecutionAttributes executionAttributes) {
        AwsSdkRequest sdkRequest;
        Span span = Span.fromContext((Context)otelContext);
        if (response instanceof AwsResponse) {
            span.setAttribute(AWS_REQUEST_ID, (Object)((AwsResponse)response).responseMetadata().requestId());
        }
        if (BedrockRuntimeAccess.isBedrockRuntimeResponse(response)) {
            BedrockRuntimeAccess.recordResponseEvents(otelContext, this.eventLogger, executionAttributes, response, this.genAiCaptureMessageContent);
        }
        if ((sdkRequest = (AwsSdkRequest)((Object)executionAttributes.getAttribute(AWS_SDK_REQUEST_ATTRIBUTE))) != null) {
            this.fieldMapper.mapToAttributes(response, sdkRequest, span);
        }
    }

    private static String extractHttpErrorAsEvent(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null) {
            Span span = Span.fromContext((Context)otelContext);
            SdkHttpResponse response = context.httpResponse();
            if (response != null && !response.isSuccessful()) {
                int errorCode = response.statusCode();
                Optional responseBody = context.responseBody();
                if (responseBody.isPresent()) {
                    String errorMsg = new BufferedReader(new InputStreamReader((InputStream)responseBody.get(), Charset.defaultCharset())).lines().collect(Collectors.joining("\n"));
                    Attributes attributes = Attributes.of((AttributeKey)HttpAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)errorCode, HTTP_ERROR_MSG, (Object)errorMsg);
                    span.addEvent(HTTP_FAILURE_EVENT, attributes);
                    return errorMsg;
                }
            }
        }
        return null;
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null) {
            RequestSpanFinisher finisher = (RequestSpanFinisher)executionAttributes.getAttribute(REQUEST_FINISHER_ATTRIBUTE);
            finisher.finish(otelContext, executionAttributes, null, context.exception());
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private static void clearAttributes(ExecutionAttributes executionAttributes) {
        Scope scope = (Scope)executionAttributes.getAttribute(SCOPE_ATTRIBUTE);
        if (scope != null) {
            scope.close();
        }
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(PARENT_CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, null);
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, null);
        executionAttributes.putAttribute(REQUEST_FINISHER_ATTRIBUTE, null);
        executionAttributes.putAttribute(TRACING_MESSAGES_ATTRIBUTE, null);
    }

    static Context getContext(ExecutionAttributes attributes) {
        return (Context)attributes.getAttribute(CONTEXT_ATTRIBUTE);
    }

    static Context getParentContext(ExecutionAttributes attributes) {
        return (Context)attributes.getAttribute(PARENT_CONTEXT_ATTRIBUTE);
    }

    private Instrumenter<ExecutionAttributes, Response> getInstrumenter(SdkRequest request, AwsSdkRequest awsSdkRequest) {
        if (SqsAccess.isSqsProducerRequest(request)) {
            return this.producerInstrumenter;
        }
        if (BedrockRuntimeAccess.isBedrockRuntimeRequest(request)) {
            return this.bedrockRuntimeInstrumenter;
        }
        if (awsSdkRequest != null && awsSdkRequest.type() == AwsSdkRequestType.DYNAMODB) {
            return this.dynamoDbInstrumenter;
        }
        return this.requestInstrumenter;
    }

    private static interface RequestSpanFinisher {
        public void finish(Context var1, ExecutionAttributes var2, Response var3, Throwable var4);
    }
}

