/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraAttributesExtractor;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraNetworkAttributesGetter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraSqlAttributesGetter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraTelemetry;
import io.opentelemetry.semconv.SemanticAttributes;

public class CassandraTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.cassandra-4.4";
    private final OpenTelemetry openTelemetry;
    private boolean statementSanitizationEnabled = true;

    protected CassandraTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public CassandraTelemetryBuilder setStatementSanitizationEnabled(boolean enabled) {
        this.statementSanitizationEnabled = enabled;
        return this;
    }

    public CassandraTelemetry build() {
        return new CassandraTelemetry(this.createInstrumenter(this.openTelemetry, this.statementSanitizationEnabled));
    }

    protected Instrumenter<CassandraRequest, ExecutionInfo> createInstrumenter(OpenTelemetry openTelemetry, boolean statementSanitizationEnabled) {
        CassandraSqlAttributesGetter attributesGetter = new CassandraSqlAttributesGetter();
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)DbClientSpanNameExtractor.create((SqlClientAttributesGetter)attributesGetter)).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)attributesGetter).setTableAttribute(SemanticAttributes.DB_CASSANDRA_TABLE).setStatementSanitizationEnabled(statementSanitizationEnabled).build()).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)new CassandraNetworkAttributesGetter())).addAttributesExtractor((AttributesExtractor)new CassandraAttributesExtractor()).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

