/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

final class CassandraNetworkAttributesGetter
implements NetworkAttributesGetter<CassandraRequest, ExecutionInfo> {
    CassandraNetworkAttributesGetter() {
    }

    @Nullable
    public InetSocketAddress getNetworkPeerInetSocketAddress(CassandraRequest request, @Nullable ExecutionInfo executionInfo) {
        if (executionInfo == null) {
            return null;
        }
        Node coordinator = executionInfo.getCoordinator();
        if (coordinator == null) {
            return null;
        }
        SocketAddress address = coordinator.getEndPoint().resolve();
        return address instanceof InetSocketAddress ? (InetSocketAddress)address : null;
    }
}

