/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.SniEndPoint;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

final class CassandraNetworkAttributesGetter
implements NetworkAttributesGetter<CassandraRequest, ExecutionInfo> {
    CassandraNetworkAttributesGetter() {
    }

    @Nullable
    public InetSocketAddress getNetworkPeerInetSocketAddress(CassandraRequest request, @Nullable ExecutionInfo executionInfo) {
        if (executionInfo == null) {
            return null;
        }
        Node coordinator = executionInfo.getCoordinator();
        if (coordinator == null) {
            return null;
        }
        EndPoint endPoint = coordinator.getEndPoint();
        if (endPoint instanceof DefaultEndPoint) {
            return (InetSocketAddress)coordinator.getEndPoint().resolve();
        }
        if (endPoint instanceof SniEndPoint) {
            return ((SniEndPoint)endPoint).resolve();
        }
        return null;
    }
}

