/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.SniEndPoint;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import io.opentelemetry.semconv.ServerAttributes;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CassandraAttributesExtractor
implements AttributesExtractor<CassandraRequest, ExecutionInfo> {
    private static final Logger logger = Logger.getLogger(CassandraAttributesExtractor.class.getName());
    private static final AttributeKey<String> DB_CASSANDRA_CONSISTENCY_LEVEL = AttributeKey.stringKey((String)"db.cassandra.consistency_level");
    private static final AttributeKey<String> DB_CASSANDRA_COORDINATOR_DC = AttributeKey.stringKey((String)"db.cassandra.coordinator.dc");
    private static final AttributeKey<String> DB_CASSANDRA_COORDINATOR_ID = AttributeKey.stringKey((String)"db.cassandra.coordinator.id");
    private static final AttributeKey<Boolean> DB_CASSANDRA_IDEMPOTENCE = AttributeKey.booleanKey((String)"db.cassandra.idempotence");
    private static final AttributeKey<Long> DB_CASSANDRA_PAGE_SIZE = AttributeKey.longKey((String)"db.cassandra.page_size");
    private static final AttributeKey<Long> DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT = AttributeKey.longKey((String)"db.cassandra.speculative_execution_count");
    private static final Field proxyAddressField = CassandraAttributesExtractor.getProxyAddressField();

    CassandraAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, CassandraRequest request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, CassandraRequest request, @Nullable ExecutionInfo executionInfo, @Nullable Throwable error) {
        if (executionInfo == null) {
            return;
        }
        Node coordinator = executionInfo.getCoordinator();
        if (coordinator != null) {
            CassandraAttributesExtractor.updateServerAddressAndPort(attributes, coordinator);
            if (coordinator.getDatacenter() != null) {
                attributes.put(DB_CASSANDRA_COORDINATOR_DC, (Object)coordinator.getDatacenter());
            }
            if (coordinator.getHostId() != null) {
                attributes.put(DB_CASSANDRA_COORDINATOR_ID, (Object)coordinator.getHostId().toString());
            }
        }
        attributes.put(DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT, executionInfo.getSpeculativeExecutionCount());
        Statement statement = (Statement)executionInfo.getRequest();
        DriverExecutionProfile config = request.getSession().getContext().getConfig().getDefaultProfile();
        String consistencyLevel = statement.getConsistencyLevel() != null ? statement.getConsistencyLevel().name() : config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY);
        attributes.put(DB_CASSANDRA_CONSISTENCY_LEVEL, (Object)consistencyLevel);
        if (statement.getPageSize() > 0) {
            attributes.put(DB_CASSANDRA_PAGE_SIZE, statement.getPageSize());
        } else {
            int pageSize = config.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE);
            if (pageSize > 0) {
                attributes.put(DB_CASSANDRA_PAGE_SIZE, pageSize);
            }
        }
        Boolean idempotent = statement.isIdempotent();
        if (idempotent == null) {
            idempotent = config.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE);
        }
        attributes.put(DB_CASSANDRA_IDEMPOTENCE, (Object)idempotent);
    }

    private static void updateServerAddressAndPort(AttributesBuilder attributes, Node coordinator) {
        EndPoint endPoint = coordinator.getEndPoint();
        if (endPoint instanceof DefaultEndPoint) {
            InetSocketAddress address = ((DefaultEndPoint)endPoint).resolve();
            attributes.put(ServerAttributes.SERVER_ADDRESS, (Object)address.getHostString());
            attributes.put(ServerAttributes.SERVER_PORT, address.getPort());
        } else if (endPoint instanceof SniEndPoint && proxyAddressField != null) {
            SniEndPoint sniEndPoint = (SniEndPoint)endPoint;
            Object object = null;
            try {
                object = proxyAddressField.get(sniEndPoint);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error when accessing the private field proxyAddress of SniEndPoint using reflection.", e);
            }
            if (object instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)object;
                attributes.put(ServerAttributes.SERVER_ADDRESS, (Object)address.getHostString());
                attributes.put(ServerAttributes.SERVER_PORT, address.getPort());
            }
        }
    }

    @Nullable
    private static Field getProxyAddressField() {
        try {
            Field field = SniEndPoint.class.getDeclaredField("proxyAddress");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            return null;
        }
    }
}

