/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.config.bridge;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

final class DeclarativeConfigPropertiesBridge
implements ConfigProperties {
    private static final String OTEL_INSTRUMENTATION_PREFIX = "otel.instrumentation.";
    private final DeclarativeConfigProperties baseNode;
    private final Map<String, String> mappings;
    private final Map<String, Object> overrideValues;

    DeclarativeConfigPropertiesBridge(DeclarativeConfigProperties baseNode, Map<String, String> mappings, Map<String, Object> overrideValues) {
        this.baseNode = Objects.requireNonNull(baseNode);
        this.mappings = mappings;
        this.overrideValues = overrideValues;
    }

    @Nullable
    public String getString(String propertyName) {
        return this.getPropertyValue(propertyName, String.class, DeclarativeConfigProperties::getString);
    }

    @Nullable
    public Boolean getBoolean(String propertyName) {
        return this.getPropertyValue(propertyName, Boolean.class, DeclarativeConfigProperties::getBoolean);
    }

    @Nullable
    public Integer getInt(String propertyName) {
        return this.getPropertyValue(propertyName, Integer.class, DeclarativeConfigProperties::getInt);
    }

    @Nullable
    public Long getLong(String propertyName) {
        return this.getPropertyValue(propertyName, Long.class, DeclarativeConfigProperties::getLong);
    }

    @Nullable
    public Double getDouble(String propertyName) {
        return this.getPropertyValue(propertyName, Double.class, DeclarativeConfigProperties::getDouble);
    }

    @Nullable
    public Duration getDuration(String propertyName) {
        Long millis = this.getPropertyValue(propertyName, Long.class, DeclarativeConfigProperties::getLong);
        if (millis == null) {
            return null;
        }
        return Duration.ofMillis(millis);
    }

    public List<String> getList(String propertyName) {
        List propertyValue = this.getPropertyValue(propertyName, (Object o) -> (List)o, (DeclarativeConfigProperties properties, String lastPart) -> properties.getScalarList(lastPart, String.class));
        return propertyValue == null ? Collections.emptyList() : propertyValue;
    }

    public Map<String, String> getMap(String propertyName) {
        DeclarativeConfigProperties propertyValue = this.getPropertyValue(propertyName, DeclarativeConfigProperties.class, DeclarativeConfigProperties::getStructured);
        if (propertyValue == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        propertyValue.getPropertyKeys().forEach(key -> {
            String value = propertyValue.getString(key);
            if (value == null) {
                return;
            }
            result.put(key, value);
        });
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    private <T> T getPropertyValue(String property, Class<T> clazz, BiFunction<DeclarativeConfigProperties, String, T> extractor) {
        return (T)this.getPropertyValue(property, clazz::cast, extractor);
    }

    @Nullable
    private <T> T getPropertyValue(String property, Function<Object, T> converter, BiFunction<DeclarativeConfigProperties, String, T> extractor) {
        T override = converter.apply(this.overrideValues.get(property));
        if (override != null) {
            return override;
        }
        String[] segments = DeclarativeConfigPropertiesBridge.getSegments(this.translateProperty(property));
        if (segments.length == 0) {
            return null;
        }
        DeclarativeConfigProperties target = this.baseNode;
        if (segments.length > 1) {
            for (int i = 0; i < segments.length - 1; ++i) {
                target = target.getStructured(segments[i], DeclarativeConfigProperties.empty());
            }
        }
        String lastPart = segments[segments.length - 1];
        return extractor.apply(target, lastPart);
    }

    static String[] getSegments(String property) {
        if (property.startsWith(OTEL_INSTRUMENTATION_PREFIX)) {
            property = property.substring(OTEL_INSTRUMENTATION_PREFIX.length());
        }
        return property.replace('-', '_').split("\\.");
    }

    private String translateProperty(String property) {
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            if (!property.startsWith(entry.getKey())) continue;
            return entry.getValue() + property.substring(entry.getKey().length());
        }
        return property;
    }
}

