/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.config.bridge;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.instrumentation.config.bridge.DeclarativeConfigPropertiesBridge;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class DeclarativeConfigPropertiesBridgeBuilder {
    private final Map<String, String> mappings = new LinkedHashMap<String, String>();
    private final Map<String, Object> overrideValues = new HashMap<String, Object>();

    @CanIgnoreReturnValue
    public DeclarativeConfigPropertiesBridgeBuilder addMapping(String propertyPrefix, String yamlPath) {
        this.mappings.put(propertyPrefix, yamlPath);
        return this;
    }

    @CanIgnoreReturnValue
    public DeclarativeConfigPropertiesBridgeBuilder addOverride(String propertyName, Object value) {
        this.overrideValues.put(propertyName, value);
        return this;
    }

    public ConfigProperties build(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        ConfigProperties sdkConfigProperties = AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        if (sdkConfigProperties != null) {
            return sdkConfigProperties;
        }
        ConfigProvider configProvider = AutoConfigureUtil.getConfigProvider((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        if (configProvider != null) {
            return this.buildFromInstrumentationConfig(configProvider.getInstrumentationConfig());
        }
        throw new IllegalStateException("AutoConfiguredOpenTelemetrySdk does not have ConfigProperties or DeclarativeConfigProperties. This is likely a programming error in opentelemetry-java");
    }

    public ConfigProperties build(@Nullable DeclarativeConfigProperties node) {
        return new DeclarativeConfigPropertiesBridge(node == null ? DeclarativeConfigProperties.empty() : node, this.mappings, this.overrideValues);
    }

    public ConfigProperties buildFromInstrumentationConfig(@Nullable DeclarativeConfigProperties instrumentationConfig) {
        return this.build(instrumentationConfig == null ? null : instrumentationConfig.getStructured("java"));
    }
}

