/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcServerMetrics;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcAttributesExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequestGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRpcAttributesGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcSpanStatusExtractor;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import io.opentelemetry.instrumentation.grpc.v1_6.internal.GrpcNetClientAttributesGetter;
import io.opentelemetry.instrumentation.grpc.v1_6.internal.GrpcNetServerAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class GrpcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.grpc-1.6";
    private final OpenTelemetry openTelemetry;
    @Nullable
    private String peerService;
    @Nullable
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractorTransformer;
    @Nullable
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractorTransformer;
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalClientExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalServerExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private boolean captureExperimentalSpanAttributes;

    GrpcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addClientAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalClientExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addServerAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalServerExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setClientSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractor) {
        this.clientSpanNameExtractorTransformer = clientSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setServerSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractor) {
        this.serverSpanNameExtractorTransformer = serverSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setPeerService(String peerService) {
        this.peerService = peerService;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    public GrpcTelemetry build() {
        SpanNameExtractor<? super GrpcRequest> originalSpanNameExtractor;
        SpanNameExtractor<? super GrpcRequest> clientSpanNameExtractor = originalSpanNameExtractor = new SpanNameExtractor<GrpcRequest>();
        if (this.clientSpanNameExtractorTransformer != null) {
            clientSpanNameExtractor = this.clientSpanNameExtractorTransformer.apply((SpanNameExtractor<GrpcRequest>)originalSpanNameExtractor);
        }
        SpanNameExtractor<? super GrpcRequest> serverSpanNameExtractor = originalSpanNameExtractor;
        if (this.serverSpanNameExtractorTransformer != null) {
            serverSpanNameExtractor = this.serverSpanNameExtractorTransformer.apply(originalSpanNameExtractor);
        }
        InstrumenterBuilder clientInstrumenterBuilder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, clientSpanNameExtractor);
        InstrumenterBuilder serverInstrumenterBuilder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, serverSpanNameExtractor);
        Stream.of(clientInstrumenterBuilder, serverInstrumenterBuilder).forEach(instrumenter -> instrumenter.setSpanStatusExtractor((SpanStatusExtractor)new GrpcSpanStatusExtractor()).addAttributesExtractor((AttributesExtractor)new GrpcAttributesExtractor()).addAttributesExtractors(this.additionalExtractors));
        GrpcNetClientAttributesGetter netClientAttributesGetter = new GrpcNetClientAttributesGetter();
        GrpcRpcAttributesGetter rpcAttributesGetter = GrpcRpcAttributesGetter.INSTANCE;
        clientInstrumenterBuilder.addAttributesExtractor((AttributesExtractor)RpcClientAttributesExtractor.create((RpcAttributesGetter)rpcAttributesGetter)).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netClientAttributesGetter)).addAttributesExtractors(this.additionalClientExtractors).addOperationMetrics(RpcClientMetrics.get());
        serverInstrumenterBuilder.addAttributesExtractor((AttributesExtractor)RpcServerAttributesExtractor.create((RpcAttributesGetter)rpcAttributesGetter)).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)new GrpcNetServerAttributesGetter())).addAttributesExtractors(this.additionalServerExtractors).addOperationMetrics(RpcServerMetrics.get());
        if (this.peerService != null) {
            clientInstrumenterBuilder.addAttributesExtractor(AttributesExtractor.constant((AttributeKey)SemanticAttributes.PEER_SERVICE, (Object)this.peerService));
        }
        return new GrpcTelemetry((Instrumenter<GrpcRequest, Status>)serverInstrumenterBuilder.buildServerInstrumenter((TextMapGetter)GrpcRequestGetter.INSTANCE), (Instrumenter<GrpcRequest, Status>)clientInstrumenterBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient()), this.openTelemetry.getPropagators(), this.captureExperimentalSpanAttributes);
    }
}

