/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcHelper;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingServerInterceptor
implements ServerInterceptor {
    private static final AtomicLongFieldUpdater<TracingServerCall> MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingServerCall.class, "messageId");
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final boolean captureExperimentalSpanAttributes;

    TracingServerInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, boolean captureExperimentalSpanAttributes) {
        this.instrumenter = instrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
        TracingServerCall.TracingServerCallListener tracingServerCallListener;
        block9: {
            GrpcRequest request = new GrpcRequest(call.getMethodDescriptor(), headers, (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), call.getAuthority());
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return next.startCall(call, headers);
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            Scope ignored = context.makeCurrent();
            try {
                tracingServerCallListener = new TracingServerCall<REQUEST, RESPONSE>(call, context, request).start(headers, next);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.instrumenter.end(context, (Object)request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }
            ignored.close();
        }
        return tracingServerCallListener;
    }

    final class TracingServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final Context context;
        private final GrpcRequest request;
        volatile long messageId;

        TracingServerCall(ServerCall<REQUEST, RESPONSE> delegate, Context context, GrpcRequest request) {
            super(delegate);
            this.context = context;
            this.request = request;
        }

        TracingServerCallListener start(Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
            return new TracingServerCallListener(Contexts.interceptCall((io.grpc.Context)io.grpc.Context.current(), (ServerCall)this, (Metadata)headers, next), this.context, this.request);
        }

        public void sendMessage(RESPONSE message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            Span span = Span.fromContext((Context)this.context);
            Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, (Object)"SENT", GrpcHelper.MESSAGE_ID, (Object)MESSAGE_ID_UPDATER.incrementAndGet(this));
            span.addEvent("message", attributes);
        }

        public void close(Status status, Metadata trailers) {
            try {
                this.delegate().close(status, trailers);
            }
            catch (Throwable e) {
                TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, e);
                throw e;
            }
            TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, status.getCause());
        }

        final class TracingServerCallListener
        extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
            private final Context context;
            private final GrpcRequest request;

            TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, Context context, GrpcRequest request) {
                super(delegate);
                this.context = context;
                this.request = request;
            }

            public void onMessage(REQUEST message) {
                Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, (Object)"RECEIVED", GrpcHelper.MESSAGE_ID, (Object)MESSAGE_ID_UPDATER.incrementAndGet(TracingServerCall.this));
                Span.fromContext((Context)this.context).addEvent("message", attributes);
                this.delegate().onMessage(message);
            }

            public void onHalfClose() {
                try {
                    this.delegate().onHalfClose();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }

            public void onCancel() {
                try {
                    this.delegate().onCancel();
                    if (TracingServerInterceptor.this.captureExperimentalSpanAttributes) {
                        Span.fromContext((Context)this.context).setAttribute("grpc.canceled", true);
                    }
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
                TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.CANCELLED, null);
            }

            public void onComplete() {
                try {
                    this.delegate().onComplete();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }

            public void onReady() {
                try {
                    this.delegate().onReady();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }
        }
    }
}

