/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6.internal;

import io.grpc.Context;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContextStorageBridge
extends Context.Storage {
    private static final Logger logger = Logger.getLogger(ContextStorageBridge.class.getName());
    private static final ContextKey<io.grpc.Context> GRPC_CONTEXT = ContextKey.named((String)"grpc-context");
    private static final Context.Key<Context> OTEL_CONTEXT = io.grpc.Context.key((String)"otel-context");
    private static final Context.Key<Scope> OTEL_SCOPE = io.grpc.Context.key((String)"otel-scope");
    private final boolean propagateGrpcDeadline;

    public ContextStorageBridge(boolean propagateGrpcDeadline) {
        this.propagateGrpcDeadline = propagateGrpcDeadline;
    }

    public io.grpc.Context doAttach(io.grpc.Context toAttach) {
        Context otelContext = Context.current();
        io.grpc.Context current = (io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            current = io.grpc.Context.ROOT;
        }
        if (current == toAttach) {
            return current.withValue(OTEL_SCOPE, (Object)Scope.noop());
        }
        Context base = (Context)OTEL_CONTEXT.get(toAttach);
        Context newOtelContext = base != null ? base.with(GRPC_CONTEXT, (Object)toAttach) : Context.current().with(GRPC_CONTEXT, (Object)toAttach);
        Scope scope = newOtelContext.makeCurrent();
        return current.withValue(OTEL_SCOPE, (Object)scope);
    }

    public void detach(io.grpc.Context toDetach, io.grpc.Context toRestore) {
        Scope scope = (Scope)OTEL_SCOPE.get(toRestore);
        if (scope == null) {
            logger.log(Level.SEVERE, "Detaching context which was not attached.", new Throwable().fillInStackTrace());
        } else {
            scope.close();
        }
    }

    public io.grpc.Context current() {
        Context otelContext = Context.current();
        io.grpc.Context current = (io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            return io.grpc.Context.ROOT.withValue(OTEL_CONTEXT, (Object)otelContext);
        }
        Context previousOtelContext = (Context)OTEL_CONTEXT.get(current);
        if (previousOtelContext != otelContext) {
            if (!this.propagateGrpcDeadline) {
                current = current.fork();
            }
            return current.withValue(OTEL_CONTEXT, (Object)otelContext);
        }
        return current;
    }
}

