/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingServerInterceptor
implements ServerInterceptor {
    private static final AttributeKey<Boolean> GRPC_CANCELED = AttributeKey.booleanKey((String)"grpc.canceled");
    private static final AttributeKey<Long> GRPC_RECEIVED_MESSAGE_COUNT = AttributeKey.longKey((String)"grpc.received.message_count");
    private static final AttributeKey<Long> GRPC_SENT_MESSAGE_COUNT = AttributeKey.longKey((String)"grpc.sent.message_count");
    private static final AttributeKey<Long> MESSAGE_ID = AttributeKey.longKey((String)"message.id");
    private static final AttributeKey<String> MESSAGE_TYPE = AttributeKey.stringKey((String)"message.type");
    private static final String SENT = "SENT";
    private static final String RECEIVED = "RECEIVED";
    private static final AtomicLongFieldUpdater<TracingServerCall> SENT_MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingServerCall.class, "sentMessageId");
    private static final AtomicLongFieldUpdater<TracingServerCall> RECEIVED_MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingServerCall.class, "receivedMessageId");
    private static final VirtualField<ServerCall<?, ?>, String> AUTHORITY_FIELD = VirtualField.find(ServerCall.class, String.class);
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final boolean captureExperimentalSpanAttributes;
    private final boolean emitMessageEvents;

    TracingServerInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, boolean captureExperimentalSpanAttributes, boolean emitMessageEvents) {
        this.instrumenter = instrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.emitMessageEvents = emitMessageEvents;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
        TracingServerCall.TracingServerCallListener tracingServerCallListener;
        block10: {
            String authority = call.getAuthority();
            if (authority == null) {
                authority = (String)AUTHORITY_FIELD.get(call);
            }
            GrpcRequest request = new GrpcRequest(call.getMethodDescriptor(), headers, (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), authority);
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return next.startCall(call, headers);
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            Scope ignored = context.makeCurrent();
            try {
                tracingServerCallListener = new TracingServerCall<REQUEST, RESPONSE>(call, context, request).start(headers, next);
                if (ignored == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.instrumenter.end(context, (Object)request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }
            ignored.close();
        }
        return tracingServerCallListener;
    }

    final class TracingServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final Context context;
        private final GrpcRequest request;
        private Status status;
        volatile long sentMessageId;
        volatile long receivedMessageId;

        TracingServerCall(ServerCall<REQUEST, RESPONSE> delegate, Context context, GrpcRequest request) {
            super(delegate);
            this.context = context;
            this.request = request;
        }

        TracingServerCallListener start(Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
            return new TracingServerCallListener(Contexts.interceptCall((io.grpc.Context)io.grpc.Context.current(), (ServerCall)this, (Metadata)headers, next), this.context, this.request);
        }

        public void sendMessage(RESPONSE message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            long messageId = SENT_MESSAGE_ID_UPDATER.incrementAndGet(this);
            if (TracingServerInterceptor.this.emitMessageEvents) {
                Attributes attributes = Attributes.of((AttributeKey)MESSAGE_TYPE, (Object)TracingServerInterceptor.SENT, (AttributeKey)MESSAGE_ID, (Object)messageId);
                Span.fromContext((Context)this.context).addEvent("message", attributes);
            }
        }

        public void close(Status status, Metadata trailers) {
            this.status = status;
            try {
                this.delegate().close(status, trailers);
            }
            catch (Throwable e) {
                TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, e);
                throw e;
            }
        }

        final class TracingServerCallListener
        extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
            private final Context context;
            private final GrpcRequest request;

            TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, Context context, GrpcRequest request) {
                super(delegate);
                this.context = context;
                this.request = request;
            }

            private void end(Context context, GrpcRequest request, Status response, Throwable error) {
                if (TracingServerInterceptor.this.captureExperimentalSpanAttributes) {
                    Span span = Span.fromContext((Context)context);
                    span.setAttribute(GRPC_RECEIVED_MESSAGE_COUNT, (Object)RECEIVED_MESSAGE_ID_UPDATER.get(TracingServerCall.this));
                    span.setAttribute(GRPC_SENT_MESSAGE_COUNT, (Object)SENT_MESSAGE_ID_UPDATER.get(TracingServerCall.this));
                    if (Status.CANCELLED.equals((Object)TracingServerCall.this.status)) {
                        span.setAttribute(GRPC_CANCELED, (Object)true);
                    }
                }
                TracingServerInterceptor.this.instrumenter.end(context, (Object)request, (Object)response, error);
            }

            public void onMessage(REQUEST message) {
                long messageId = RECEIVED_MESSAGE_ID_UPDATER.incrementAndGet(TracingServerCall.this);
                if (TracingServerInterceptor.this.emitMessageEvents) {
                    Attributes attributes = Attributes.of((AttributeKey)MESSAGE_TYPE, (Object)TracingServerInterceptor.RECEIVED, (AttributeKey)MESSAGE_ID, (Object)messageId);
                    Span.fromContext((Context)this.context).addEvent("message", attributes);
                }
                this.delegate().onMessage(message);
            }

            public void onHalfClose() {
                try {
                    this.delegate().onHalfClose();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }

            public void onCancel() {
                try {
                    this.delegate().onCancel();
                }
                catch (Throwable e) {
                    this.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
                this.end(this.context, this.request, Status.CANCELLED, null);
            }

            public void onComplete() {
                try {
                    this.delegate().onComplete();
                }
                catch (Throwable e) {
                    this.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
                if (TracingServerCall.this.status == null) {
                    TracingServerCall.this.status = Status.UNKNOWN;
                }
                this.end(this.context, this.request, TracingServerCall.this.status, TracingServerCall.this.status.getCause());
            }

            public void onReady() {
                try {
                    this.delegate().onReady();
                }
                catch (Throwable e) {
                    this.end(this.context, this.request, Status.UNKNOWN, e);
                    throw e;
                }
            }
        }
    }
}

