/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.grpc.v1_6.MetadataSetter;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingClientInterceptor
implements ClientInterceptor {
    private static final AttributeKey<Long> GRPC_RECEIVED_MESSAGE_COUNT = AttributeKey.longKey((String)"grpc.received.message_count");
    private static final AttributeKey<Long> GRPC_SENT_MESSAGE_COUNT = AttributeKey.longKey((String)"grpc.sent.message_count");
    private static final AttributeKey<Long> MESSAGE_ID = AttributeKey.longKey((String)"message.id");
    private static final AttributeKey<String> MESSAGE_TYPE = AttributeKey.stringKey((String)"message.type");
    private static final String SENT = "SENT";
    private static final String RECEIVED = "RECEIVED";
    private static final AtomicLongFieldUpdater<TracingClientCall> SENT_MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingClientCall.class, "sentMessageId");
    private static final AtomicLongFieldUpdater<TracingClientCall> RECEIVED_MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingClientCall.class, "receivedMessageId");
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final ContextPropagators propagators;
    private final boolean captureExperimentalSpanAttributes;
    private final boolean emitMessageEvents;

    TracingClientInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, ContextPropagators propagators, boolean captureExperimentalSpanAttributes, boolean emitMessageEvents) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.emitMessageEvents = emitMessageEvents;
    }

    public <REQUEST, RESPONSE> ClientCall<REQUEST, RESPONSE> interceptCall(MethodDescriptor<REQUEST, RESPONSE> method, CallOptions callOptions, Channel next) {
        ClientCall result;
        GrpcRequest request = new GrpcRequest(method, null, null, next.authority());
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return next.newCall(method, callOptions);
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            result = next.newCall(method, callOptions);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)request, (Object)Status.UNKNOWN, t);
            throw t;
        }
        return new TracingClientCall(result, parentContext, context, request);
    }

    final class TracingClientCall<REQUEST, RESPONSE>
    extends ForwardingClientCall.SimpleForwardingClientCall<REQUEST, RESPONSE> {
        private final Context parentContext;
        private final Context context;
        private final GrpcRequest request;
        volatile long sentMessageId;
        volatile long receivedMessageId;

        TracingClientCall(ClientCall<REQUEST, RESPONSE> delegate, Context parentContext, Context context, GrpcRequest request) {
            super(delegate);
            this.parentContext = parentContext;
            this.context = context;
            this.request = request;
        }

        public void start(ClientCall.Listener<RESPONSE> responseListener, Metadata headers) {
            TracingClientInterceptor.this.propagators.getTextMapPropagator().inject(this.context, (Object)headers, (TextMapSetter)MetadataSetter.INSTANCE);
            this.request.setMetadata(headers);
            try (Scope ignored = this.context.makeCurrent();){
                super.start((ClientCall.Listener)new TracingClientCallListener(responseListener, this.parentContext, this.context, this.request), headers);
            }
            catch (Throwable e) {
                TracingClientInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                throw e;
            }
        }

        public void sendMessage(REQUEST message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            catch (Throwable e) {
                TracingClientInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                throw e;
            }
            long messageId = SENT_MESSAGE_ID_UPDATER.incrementAndGet(this);
            if (TracingClientInterceptor.this.emitMessageEvents) {
                Attributes attributes = Attributes.of((AttributeKey)MESSAGE_TYPE, (Object)TracingClientInterceptor.SENT, (AttributeKey)MESSAGE_ID, (Object)messageId);
                Span.fromContext((Context)this.context).addEvent("message", attributes);
            }
        }

        final class TracingClientCallListener
        extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RESPONSE> {
            private final Context parentContext;
            private final Context context;
            private final GrpcRequest request;

            TracingClientCallListener(ClientCall.Listener<RESPONSE> delegate, Context parentContext, Context context, GrpcRequest request) {
                super(delegate);
                this.parentContext = parentContext;
                this.context = context;
                this.request = request;
            }

            public void onMessage(RESPONSE message) {
                long messageId = RECEIVED_MESSAGE_ID_UPDATER.incrementAndGet(TracingClientCall.this);
                if (TracingClientInterceptor.this.emitMessageEvents) {
                    Attributes attributes = Attributes.of((AttributeKey)MESSAGE_TYPE, (Object)TracingClientInterceptor.RECEIVED, (AttributeKey)MESSAGE_ID, (Object)messageId);
                    Span.fromContext((Context)this.context).addEvent("message", attributes);
                }
                try (Scope ignored = this.context.makeCurrent();){
                    this.delegate().onMessage(message);
                }
            }

            public void onClose(Status status, Metadata trailers) {
                this.request.setPeerSocketAddress((SocketAddress)TracingClientCall.this.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                if (TracingClientInterceptor.this.captureExperimentalSpanAttributes) {
                    Span span = Span.fromContext((Context)this.context);
                    span.setAttribute(GRPC_RECEIVED_MESSAGE_COUNT, (Object)RECEIVED_MESSAGE_ID_UPDATER.get(TracingClientCall.this));
                    span.setAttribute(GRPC_SENT_MESSAGE_COUNT, (Object)SENT_MESSAGE_ID_UPDATER.get(TracingClientCall.this));
                }
                TracingClientInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, status.getCause());
                try (Scope ignored = this.parentContext.makeCurrent();){
                    this.delegate().onClose(status, trailers);
                }
            }

            public void onReady() {
                try (Scope ignored = this.context.makeCurrent();){
                    this.delegate().onReady();
                }
            }
        }
    }
}

