/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.builder.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.config.internal.CommonConfig;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientPeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> {
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey((String)"peer.service");
    private final String instrumentationName;
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> additionalExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    private Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractorTransformer = Function.identity();
    private final HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> httpAttributesExtractorBuilder;
    private final HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final HttpSpanNameExtractorBuilder<REQUEST> httpSpanNameExtractorBuilder;
    @Nullable
    private final TextMapSetter<REQUEST> headerSetter;
    private Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer = Function.identity();
    private boolean emitExperimentalHttpClientMetrics = false;
    private Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer = b -> {};

    private DefaultHttpClientInstrumenterBuilder(String instrumentationName, OpenTelemetry openTelemetry, HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, TextMapSetter<REQUEST> headerSetter) {
        this.instrumentationName = Objects.requireNonNull(instrumentationName, "instrumentationName");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry");
        this.attributesGetter = Objects.requireNonNull(attributesGetter, "attributesGetter");
        this.httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder(attributesGetter);
        this.httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder(attributesGetter);
        this.headerSetter = headerSetter;
    }

    public static <REQUEST, RESPONSE> DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, null);
    }

    public static <REQUEST, RESPONSE> DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, TextMapSetter<REQUEST> headerSetter) {
        return new DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, Objects.requireNonNull(headerSetter, "headerSetter"));
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setStatusExtractor(Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractor) {
        this.statusExtractorTransformer = statusExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setSpanNameExtractor(Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setPeerServiceResolver(PeerServiceResolver peerServiceResolver) {
        return this.addAttributesExtractor(HttpClientPeerServiceAttributesExtractor.create(this.attributesGetter, peerServiceResolver));
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setPeerService(String peerService) {
        return this.addAttributesExtractor(AttributesExtractor.constant(PEER_SERVICE, (Object)peerService));
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> setBuilderCustomizer(Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer) {
        this.builderCustomizer = builderCustomizer;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> build() {
        SpanNameExtractor<? super REQUEST> spanNameExtractor = this.spanNameExtractorTransformer.apply(this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, spanNameExtractor).setSpanStatusExtractor(this.statusExtractorTransformer.apply(HttpSpanStatusExtractor.create(this.attributesGetter))).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create(this.attributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        this.builderCustomizer.accept(builder);
        if (this.headerSetter != null) {
            return builder.buildClientInstrumenter(this.headerSetter);
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    public <BUILDERREQUEST, BUILDERRESPONSE> InstrumenterBuilder<BUILDERREQUEST, BUILDERRESPONSE> instrumenterBuilder(SpanNameExtractor<? super BUILDERREQUEST> spanNameExtractor) {
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, spanNameExtractor);
    }

    @CanIgnoreReturnValue
    public DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE> configure(CommonConfig config) {
        DefaultHttpClientInstrumenterBuilder.set(config::getKnownHttpRequestMethods, this::setKnownMethods);
        DefaultHttpClientInstrumenterBuilder.set(config::getClientRequestHeaders, this::setCapturedRequestHeaders);
        DefaultHttpClientInstrumenterBuilder.set(config::getClientResponseHeaders, this::setCapturedResponseHeaders);
        DefaultHttpClientInstrumenterBuilder.set(config::getPeerServiceResolver, this::setPeerServiceResolver);
        DefaultHttpClientInstrumenterBuilder.set(config::shouldEmitExperimentalHttpClientTelemetry, this::setEmitExperimentalHttpClientMetrics);
        return this;
    }

    private static <T> void set(Supplier<T> supplier, Consumer<T> consumer) {
        T t = supplier.get();
        if (t != null) {
            consumer.accept(t);
        }
    }
}

