/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey((String)"db.statement");
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> dbTableAttribute;
    private final SqlStatementSanitizer sanitizer;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute, SqlStatementSanitizer sanitizer) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
        this.sanitizer = sanitizer;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        SqlStatementInfo sanitizedStatement = this.sanitizer.sanitize(((SqlClientAttributesGetter)this.getter).getRawStatement(request));
        String operation = sanitizedStatement.getOperation();
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_STATEMENT, (Object)sanitizedStatement.getFullStatement());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)operation);
        if (!SQL_CALL.equals(operation)) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.dbTableAttribute, (Object)sanitizedStatement.getMainIdentifier());
        }
    }
}

