/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.messaging;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class MessagingMetricsAdvice {
    static final List<Double> DURATION_SECONDS_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0));
    private static final AttributeKey<String> MESSAGING_SYSTEM = AttributeKey.stringKey((String)"messaging.system");
    private static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey((String)"messaging.destination.name");
    private static final AttributeKey<String> MESSAGING_OPERATION = AttributeKey.stringKey((String)"messaging.operation");
    private static final AttributeKey<Long> MESSAGING_BATCH_MESSAGE_COUNT = AttributeKey.longKey((String)"messaging.batch.message_count");

    static void applyPublishDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(MESSAGING_SYSTEM, MESSAGING_DESTINATION_NAME, MESSAGING_OPERATION, MESSAGING_BATCH_MESSAGE_COUNT, ErrorAttributes.ERROR_TYPE, ServerAttributes.SERVER_PORT, ServerAttributes.SERVER_ADDRESS));
    }

    private MessagingMetricsAdvice() {
    }
}

