/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.code;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.util.ClassNames;
import javax.annotation.Nullable;

public final class CodeSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeSpanNameExtractor<REQUEST>(getter);
    }

    private CodeSpanNameExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public String extract(REQUEST request) {
        Class<?> cls = this.getter.codeClass(request);
        String className = cls != null ? ClassNames.simpleName(cls) : "<unknown>";
        String methodName = CodeSpanNameExtractor.defaultString(this.getter.methodName(request));
        return className + "." + methodName;
    }

    private static String defaultString(@Nullable String s) {
        return s == null ? "<unknown>" : s;
    }
}

