/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.internal.DeprecatedConfigPropertyWarning;

public final class ExperimentalConfig {
    private static final ExperimentalConfig instance = new ExperimentalConfig(Config.get());
    private final Config config;

    public static ExperimentalConfig get() {
        return instance;
    }

    public ExperimentalConfig(Config config) {
        this.config = config;
    }

    public boolean controllerTelemetryEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-controller-spans", "otel.instrumentation.common.experimental.controller-telemetry.enabled");
        boolean suppressControllerSpans = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-controller-spans", false);
        return this.config.getBoolean("otel.instrumentation.common.experimental.controller-telemetry.enabled", !suppressControllerSpans);
    }

    public boolean viewTelemetryEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-view-spans", "otel.instrumentation.common.experimental.view-telemetry.enabled");
        boolean suppressViewSpans = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-view-spans", false);
        return this.config.getBoolean("otel.instrumentation.common.experimental.view-telemetry.enabled", !suppressViewSpans);
    }

    public boolean messagingReceiveInstrumentationEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-messaging-receive-spans", "otel.instrumentation.messaging.experimental.receive-telemetry.enabled");
        boolean receiveSpansSuppressed = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-messaging-receive-spans", true);
        return this.config.getBoolean("otel.instrumentation.messaging.experimental.receive-telemetry.enabled", !receiveSpansSuppressed);
    }
}

