/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final Map<String, String> JAVAAGENT_PEER_SERVICE_MAPPING = Config.get().getMap("otel.instrumentation.common.peer-service-mapping", Collections.emptyMap());
    private final Map<String, String> peerServiceMapping;
    private final NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;

    PeerServiceAttributesExtractor(Map<String, String> peerServiceMapping, NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        this.peerServiceMapping = peerServiceMapping;
        this.attributesGetter = attributesGetter;
    }

    public static <REQUEST, RESPONSE> PeerServiceAttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(JAVAAGENT_PEER_SERVICE_MAPPING, attributesGetter);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (this.peerServiceMapping.isEmpty()) {
            return;
        }
        String peerName = this.attributesGetter.peerName(request, response);
        String peerService = this.mapToPeerService(peerName);
        if (peerService == null) {
            String peerIp = this.attributesGetter.peerIp(request, response);
            peerService = this.mapToPeerService(peerIp);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    @Nullable
    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

