/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeadersUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.List;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> getter;
    List<String> capturedRequestHeaders = CapturedHttpHeadersUtil.serverRequestHeaders;
    List<String> capturedResponseHeaders = CapturedHttpHeadersUtil.serverResponseHeaders;

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = requestHeaders;
        return this;
    }

    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = responseHeaders;
        return this;
    }

    public HttpServerAttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.capturedRequestHeaders, this.capturedResponseHeaders);
    }
}

