/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

final class CapturedHttpHeadersUtil {
    private static final String CLIENT_REQUEST_PROPERTY = "otel.instrumentation.http.capture-headers.client.request";
    private static final String CLIENT_RESPONSE_PROPERTY = "otel.instrumentation.http.capture-headers.client.response";
    private static final String SERVER_REQUEST_PROPERTY = "otel.instrumentation.http.capture-headers.server.request";
    private static final String SERVER_RESPONSE_PROPERTY = "otel.instrumentation.http.capture-headers.server.response";
    static final List<String> clientRequestHeaders;
    static final List<String> clientResponseHeaders;
    static final List<String> serverRequestHeaders;
    static final List<String> serverResponseHeaders;
    private static final ConcurrentMap<String, AttributeKey<List<String>>> requestKeysCache;
    private static final ConcurrentMap<String, AttributeKey<List<String>>> responseKeysCache;

    static List<String> lowercase(List<String> names) {
        return Collections.unmodifiableList(names.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
    }

    static AttributeKey<List<String>> requestAttributeKey(String headerName) {
        return requestKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createKey("request", n));
    }

    static AttributeKey<List<String>> responseAttributeKey(String headerName) {
        return responseKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createKey("response", n));
    }

    private static AttributeKey<List<String>> createKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey((String)key);
    }

    private CapturedHttpHeadersUtil() {
    }

    static {
        Config config = Config.get();
        clientRequestHeaders = config.getList(CLIENT_REQUEST_PROPERTY, Collections.emptyList());
        clientResponseHeaders = config.getList(CLIENT_RESPONSE_PROPERTY, Collections.emptyList());
        serverRequestHeaders = config.getList(SERVER_REQUEST_PROPERTY, Collections.emptyList());
        serverResponseHeaders = config.getList(SERVER_RESPONSE_PROPERTY, Collections.emptyList());
        requestKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
        responseKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    }
}

