/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetServerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetServerAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> NetServerAttributesExtractor<REQUEST, RESPONSE> create(NetServerAttributesGetter<REQUEST> getter) {
        return new NetServerAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetServerAttributesExtractor(NetServerAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)this.getter.transport(request));
        String peerIp = this.getter.peerIp(request);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_IP, (Object)peerIp);
        Integer peerPort = this.getter.peerPort(request);
        if (peerPort != null && peerPort > 0) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_PORT, (Object)peerPort);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

