/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named((String)"http-server-request-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpServerMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("requests").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = meter.histogramBuilder("http.server.duration").setUnit("ms").setDescription("The duration of the inbound HTTP request").build();
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, TemporaryMetricsView.applyActiveRequestsView(startAttributes), context);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = (State)context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, TemporaryMetricsView.applyActiveRequestsView(state.startAttributes()), context);
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, TemporaryMetricsView.applyServerDurationView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

