/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public abstract class InetSocketAddressNetClientAttributesGetter<REQUEST, RESPONSE>
implements NetClientAttributesGetter<REQUEST, RESPONSE> {
    @Nullable
    public abstract InetSocketAddress getAddress(REQUEST var1, @Nullable RESPONSE var2);

    @Override
    @Nullable
    public final String peerName(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        return address.getHostString();
    }

    @Override
    @Nullable
    public final Integer peerPort(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        return address.getPort();
    }

    @Override
    @Nullable
    public final String sockPeerAddr(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        InetAddress remoteAddress = address.getAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }

    @Override
    @Nullable
    public Integer sockPeerPort(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        return address.getPort();
    }

    @Override
    @Nullable
    public String sockFamily(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        InetAddress remoteAddress = address.getAddress();
        if (remoteAddress instanceof Inet6Address) {
            return "inet6";
        }
        return null;
    }
}

