/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.util;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.instrumentation.api.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.util.ClassNames;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class SpanNames {
    private static final Cache<Class<?>, Map<String, String>> spanNameCaches = Cache.weak();

    public static String fromMethod(Method method) {
        return SpanNames.fromMethod(method.getDeclaringClass(), method.getName());
    }

    @Deprecated
    public static String fromMethod(Class<?> clazz, @Nullable Method method) {
        return SpanNames.fromMethod(clazz, method == null ? "<unknown>" : method.getName());
    }

    @Deprecated
    public static String fromMethod(ClassAndMethod classAndMethod) {
        return SpanNames.fromMethod(classAndMethod.declaringClass(), classAndMethod.methodName());
    }

    public static String fromMethod(Class<?> clazz, String methodName) {
        Map spanNameCache = (Map)spanNameCaches.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
        String spanName = (String)spanNameCache.get(methodName);
        if (spanName != null) {
            return spanName;
        }
        spanName = ClassNames.simpleName(clazz) + "." + methodName;
        spanNameCache.put(methodName, spanName);
        return spanName;
    }

    private SpanNames() {
    }
}

