/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Objects;

public final class SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    AttributeKey<String> dbTableAttribute = SemanticAttributes.DB_SQL_TABLE;
    boolean statementSanitizationEnabled = true;

    SqlClientAttributesExtractorBuilder(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setTableAttribute(AttributeKey<String> dbTableAttribute) {
        this.dbTableAttribute = Objects.requireNonNull(dbTableAttribute);
        return this;
    }

    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    public SqlClientAttributesExtractor<REQUEST, RESPONSE> build() {
        return new SqlClientAttributesExtractor(this.getter, this.dbTableAttribute, SqlStatementSanitizer.create(this.statementSanitizationEnabled));
    }
}

