/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetAttributes;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetServerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetServerAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> NetServerAttributesExtractor<REQUEST, RESPONSE> create(NetServerAttributesGetter<REQUEST> getter) {
        return new NetServerAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetServerAttributesExtractor(NetServerAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String sockFamily;
        String sockHostAddr;
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)this.getter.transport(request));
        boolean setSockFamily = false;
        String sockPeerAddr = this.getter.sockPeerAddr(request);
        if (sockPeerAddr != null) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetAttributes.NET_SOCK_PEER_ADDR, (Object)sockPeerAddr);
            Integer sockPeerPort = this.getter.sockPeerPort(request);
            if (sockPeerPort != null && sockPeerPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetAttributes.NET_SOCK_PEER_PORT, (Object)sockPeerPort);
            }
        }
        String hostName = this.getter.hostName(request);
        Integer hostPort = this.getter.hostPort(request);
        if (hostName != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_NAME, (Object)hostName);
            if (hostPort != null && hostPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_PORT, (Object)hostPort);
            }
        }
        if ((sockHostAddr = this.getter.sockHostAddr(request)) != null && !sockHostAddr.equals(hostName)) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetAttributes.NET_SOCK_HOST_ADDR, (Object)sockHostAddr);
            Integer sockHostPort = this.getter.sockHostPort(request);
            if (sockHostPort != null && sockHostPort > 0 && !sockHostPort.equals(hostPort)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetAttributes.NET_SOCK_HOST_PORT, (Object)sockHostPort);
            }
        }
        if (setSockFamily && (sockFamily = this.getter.sockFamily(request)) != null && !"inet".equals(sockFamily)) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetAttributes.NET_SOCK_FAMILY, (Object)sockFamily);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

