/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpClientMetrics
implements OperationListener {
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named((String)"http-client-request-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpClientMetrics.class.getName());
    private final DoubleHistogram duration;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        this.duration = HttpMetricsUtil.createDurationHistogram(meter, "http.client.duration", "The duration of the outbound HTTP request");
        this.requestSize = meter.histogramBuilder("http.client.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.client.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        State state = (State)context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes durationAndSizeAttributes = TemporaryMetricsView.applyClientDurationAndSizeView(state.startAttributes(), endAttributes);
        this.duration.record(HttpMetricsUtil.nanosToUnit(endNanos - state.startTimeNanos()), durationAndSizeAttributes, context);
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, state.startAttributes());
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize.longValue(), durationAndSizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, state.startAttributes())) != null) {
            this.responseSize.record(responseBodySize.longValue(), durationAndSizeAttributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

