/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.ClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class InternalClientAttributesExtractor<REQUEST, RESPONSE> {
    private final ClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalClientAttributesExtractor(ClientAttributesGetter<REQUEST, RESPONSE> getter, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String clientAddress = this.extractClientAddress(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.CLIENT_ADDRESS, (Object)clientAddress);
            Integer clientPort = this.extractClientPort(request);
            if (clientPort != null && clientPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.CLIENT_PORT, (Object)clientPort);
            }
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_CLIENT_IP, (Object)clientAddress);
        }
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String clientAddress = this.extractClientAddress(request);
        String clientSocketAddress = this.getter.getClientSocketAddress(request, response);
        Integer clientSocketPort = this.getter.getClientSocketPort(request, response);
        if (clientSocketAddress != null && !clientSocketAddress.equals(clientAddress)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.CLIENT_SOCKET_ADDRESS, (Object)clientSocketAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)clientSocketAddress);
            }
        }
        if (clientSocketPort != null && clientSocketPort > 0) {
            Integer clientPort;
            if (this.emitStableUrlAttributes && !clientSocketPort.equals(clientPort = this.extractClientPort(request))) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.CLIENT_SOCKET_PORT, (Object)clientSocketPort);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)clientSocketPort);
            }
        }
    }

    private String extractClientAddress(REQUEST request) {
        String clientAddress = this.getter.getClientAddress(request);
        if (clientAddress == null) {
            clientAddress = this.fallbackNamePortGetter.name(request);
        }
        return clientAddress;
    }

    private Integer extractClientPort(REQUEST request) {
        Integer clientPort = this.getter.getClientPort(request);
        if (clientPort == null) {
            clientPort = this.fallbackNamePortGetter.port(request);
        }
        return clientPort;
    }
}

