/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public final class InternalServerAttributesExtractor<REQUEST, RESPONSE> {
    private final ServerAttributesGetter<REQUEST, RESPONSE> getter;
    private final BiPredicate<Integer, REQUEST> captureServerPortCondition;
    private final FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;
    private final Mode oldSemconvMode;

    public InternalServerAttributesExtractor(ServerAttributesGetter<REQUEST, RESPONSE> getter, BiPredicate<Integer, REQUEST> captureServerPortCondition, FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes, Mode oldSemconvMode) {
        this.getter = getter;
        this.captureServerPortCondition = captureServerPortCondition;
        this.fallbackAddressPortExtractor = fallbackAddressPortExtractor;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
        this.oldSemconvMode = oldSemconvMode;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort serverAddressAndPort = this.extractServerAddressAndPort(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.SERVER_ADDRESS, (Object)serverAddressAndPort.address);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.address, (Object)serverAddressAndPort.address);
        }
        if (serverAddressAndPort.port != null && serverAddressAndPort.port > 0 && this.captureServerPortCondition.test(serverAddressAndPort.port, request)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.SERVER_PORT, (Object)serverAddressAndPort.port);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.port, (Object)serverAddressAndPort.port);
            }
        }
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String serverSocketDomain;
        Integer serverSocketPort;
        AddressAndPort serverAddressAndPort = this.extractServerAddressAndPort(request);
        String serverSocketAddress = this.getter.getServerSocketAddress(request, response);
        if (serverSocketAddress != null && !serverSocketAddress.equals(serverAddressAndPort.address)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.SERVER_SOCKET_ADDRESS, (Object)serverSocketAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.socketAddress, (Object)serverSocketAddress);
            }
        }
        if ((serverSocketPort = this.getter.getServerSocketPort(request, response)) != null && serverSocketPort > 0 && !serverSocketPort.equals(serverAddressAndPort.port)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.SERVER_SOCKET_PORT, (Object)serverSocketPort);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.socketPort, (Object)serverSocketPort);
            }
        }
        if ((serverSocketDomain = this.getter.getServerSocketDomain(request, response)) != null && !serverSocketDomain.equals(serverAddressAndPort.address)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, NetworkAttributes.SERVER_SOCKET_DOMAIN, (Object)serverSocketDomain);
            }
            if (this.emitOldHttpAttributes && this.oldSemconvMode.socketDomain != null) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.socketDomain, (Object)serverSocketDomain);
            }
        }
    }

    private AddressAndPort extractServerAddressAndPort(REQUEST request) {
        AddressAndPort addressAndPort = new AddressAndPort();
        addressAndPort.address = this.getter.getServerAddress(request);
        addressAndPort.port = this.getter.getServerPort(request);
        if (addressAndPort.address == null && addressAndPort.port == null) {
            this.fallbackAddressPortExtractor.extract(addressAndPort, request);
        }
        return addressAndPort;
    }

    public static enum Mode {
        PEER((AttributeKey<String>)SemanticAttributes.NET_PEER_NAME, (AttributeKey<Long>)SemanticAttributes.NET_PEER_PORT, (AttributeKey<String>)SemanticAttributes.NET_SOCK_PEER_NAME, (AttributeKey<String>)SemanticAttributes.NET_SOCK_PEER_ADDR, (AttributeKey<Long>)SemanticAttributes.NET_SOCK_PEER_PORT),
        HOST((AttributeKey<String>)SemanticAttributes.NET_HOST_NAME, (AttributeKey<Long>)SemanticAttributes.NET_HOST_PORT, null, (AttributeKey<String>)SemanticAttributes.NET_SOCK_HOST_ADDR, (AttributeKey<Long>)SemanticAttributes.NET_SOCK_HOST_PORT);

        final AttributeKey<String> address;
        final AttributeKey<Long> port;
        @Nullable
        final AttributeKey<String> socketDomain;
        final AttributeKey<String> socketAddress;
        final AttributeKey<Long> socketPort;

        private Mode(AttributeKey<String> address, AttributeKey<Long> port, AttributeKey<String> socketDomain, AttributeKey<String> socketAddress, AttributeKey<Long> socketPort) {
            this.address = address;
            this.port = port;
            this.socketDomain = socketDomain;
            this.socketAddress = socketAddress;
            this.socketPort = socketPort;
        }
    }
}

