/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    public static final String CONTEXT_ATTRIBUTE = HttpServerTracer.class.getName() + ".Context";
    protected static final String USER_AGENT = "User-Agent";

    public HttpServerTracer() {
    }

    @Deprecated
    public HttpServerTracer(Tracer tracer) {
        super(tracer);
    }

    public HttpServerTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, Method origin) {
        String spanName = this.spanNameForMethod(origin);
        return this.startSpan(request, connection, storage, spanName);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, String spanName) {
        return this.startSpan(request, connection, storage, spanName, -1L);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, @Nullable STORAGE storage, String spanName, long startTimestamp) {
        Context parentContext = this.extract(request, this.getGetter());
        SpanBuilder builder = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.SERVER).setParent(parentContext);
        if (startTimestamp >= 0L) {
            builder.setStartTimestamp(startTimestamp, TimeUnit.NANOSECONDS);
        }
        Span span = builder.startSpan();
        this.onConnection(span, connection);
        this.onRequest(span, request);
        this.onConnectionAndRequest(span, connection, request);
        Context context = this.withServerSpan(parentContext, span);
        this.attachServerContext(context, storage);
        return context;
    }

    public void end(Context context, RESPONSE response) {
        this.end(context, response, -1L);
    }

    public void end(Context context, RESPONSE response, long timestamp) {
        Span span = Span.fromContext((Context)context);
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        HttpServerTracer.endSpan(span, timestamp);
    }

    @Override
    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, null);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response) {
        this.endExceptionally(context, throwable, response, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response, long timestamp) {
        Span span = Span.fromContext((Context)context);
        this.onError(span, this.unwrapThrowable(throwable));
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        HttpServerTracer.endSpan(span, timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : HttpServerTracer.getCurrentServerSpan(attachedContext);
    }

    public abstract @Nullable Context getServerContext(STORAGE var1);

    protected void onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        }
    }

    protected void onRequest(Span span, REQUEST request) {
        span.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)this.method(request));
        span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)this.requestHeader(request, USER_AGENT));
        this.setUrl(span, request);
    }

    private void setUrl(Span span, REQUEST request) {
        span.setAttribute(SemanticAttributes.HTTP_URL, (Object)this.url(request));
    }

    protected void onConnectionAndRequest(Span span, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)flavor);
        }
        span.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)this.clientIP(connection, request));
    }

    private String clientIP(CONNECTION connection, REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null) {
            int endIndex = forwarded.indexOf(44);
            if (endIndex > 0) {
                forwarded = forwarded.substring(0, endIndex);
            }
            if (!forwarded.isEmpty()) {
                return forwarded;
            }
        }
        return this.peerHostIP(connection);
    }

    static String extractForwardedFor(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private static void setStatus(Span span, int status) {
        span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, (Object)status);
        span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
    }

    private static void endSpan(Span span, long timestamp) {
        if (timestamp >= 0L) {
            span.end(timestamp, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    protected abstract @Nullable Integer peerPort(CONNECTION var1);

    protected abstract @Nullable String peerHostIP(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract TextMapPropagator.Getter<REQUEST> getGetter();

    protected abstract String url(REQUEST var1);

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);

    protected boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }
}

