/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlAttributesExtractor;
import javax.annotation.Nullable;

public final class DbSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";
    private final DbAttributesExtractor<REQUEST, ?> attributesExtractor;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbAttributesExtractor<REQUEST, ?> attributesExtractor) {
        return new DbSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private DbSpanNameExtractor(DbAttributesExtractor<REQUEST, ?> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public String extract(REQUEST request) {
        String operation = this.attributesExtractor.operation(request);
        String dbName = this.attributesExtractor.name(request);
        if (operation == null) {
            return dbName == null ? DEFAULT_SPAN_NAME : dbName;
        }
        String table = this.getTableName(request);
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || table != null) {
            name.append(' ');
        }
        if (dbName != null && (table == null || table.indexOf(46) == -1)) {
            name.append(dbName);
            if (table != null) {
                name.append('.');
            }
        }
        if (table != null) {
            name.append(table);
        }
        return name.toString();
    }

    @Nullable
    private String getTableName(REQUEST request) {
        if (this.attributesExtractor instanceof SqlAttributesExtractor) {
            return ((SqlAttributesExtractor)this.attributesExtractor).table(request);
        }
        return null;
    }
}

