/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.instrumentation.api.cache.Cache;
import io.opentelemetry.instrumentation.api.field.VirtualField;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeVirtualFieldSupplier {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeVirtualFieldSupplier.class);
    private static final VirtualFieldSupplier DEFAULT;
    private static volatile VirtualFieldSupplier instance;

    public static void set(VirtualFieldSupplier virtualFieldSupplier) {
        if (instance != DEFAULT) {
            logger.warn("Runtime VirtualField supplier has already been set up, further set() calls are ignored");
            return;
        }
        instance = virtualFieldSupplier;
    }

    public static VirtualFieldSupplier get() {
        return instance;
    }

    private RuntimeVirtualFieldSupplier() {
    }

    static {
        instance = DEFAULT = new CacheBasedVirtualFieldSupplier();
    }

    private static final class CacheBasedVirtualField<T, F>
    extends VirtualField<T, F> {
        private final Cache<T, F> cache = Cache.weak();

        private CacheBasedVirtualField() {
        }

        @Override
        @Nullable
        public F get(T object) {
            return this.cache.get(object);
        }

        @Override
        public void set(T object, @Nullable F fieldValue) {
            if (fieldValue == null) {
                this.cache.remove(object);
            } else {
                this.cache.put(object, fieldValue);
            }
        }
    }

    private static final class CacheBasedVirtualFieldSupplier
    implements VirtualFieldSupplier {
        private final Cache<Class<?>, Cache<Class<?>, VirtualField<?, ?>>> ownerToFieldToImplementationMap = Cache.weak();

        private CacheBasedVirtualFieldSupplier() {
        }

        @Override
        public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> type, Class<F> fieldType) {
            return this.ownerToFieldToImplementationMap.computeIfAbsent(type, c -> Cache.weak()).computeIfAbsent(fieldType, c -> new CacheBasedVirtualField());
        }
    }

    public static interface VirtualFieldSupplier {
        public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> var1, Class<F> var2);
    }
}

