/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import io.opentelemetry.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.instrumentation.api.config.Config;

@UnstableApi
public final class ExperimentalConfig {
    private static final ExperimentalConfig instance = new ExperimentalConfig(Config.get());
    private final Config config;

    public static ExperimentalConfig get() {
        return instance;
    }

    public ExperimentalConfig(Config config) {
        this.config = config;
    }

    public boolean suppressControllerSpans() {
        return this.config.getBoolean("otel.instrumentation.common.experimental.suppress-controller-spans", false);
    }

    public boolean suppressViewSpans() {
        return this.config.getBoolean("otel.instrumentation.common.experimental.suppress-view-spans", false);
    }

    public boolean messagingReceiveInstrumentationEnabled() {
        boolean receiveSpansSuppressed = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-messaging-receive-spans", true);
        return this.config.getBoolean("otel.instrumentation.messaging.experimental.receive-telemetry.enabled", !receiveSpansSuppressed);
    }
}

