/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class HttpClientAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpClientAttributesGetter<REQUEST, RESPONSE>> {
    public static <REQUEST, RESPONSE> HttpClientAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpClientAttributesExtractor.builder(getter).build();
    }

    @Deprecated
    public static <REQUEST, RESPONSE> HttpClientAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders) {
        return HttpClientAttributesExtractor.builder(getter).captureHttpHeaders(capturedHttpHeaders).build();
    }

    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    HttpClientAttributesExtractor(HttpClientAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders) {
        super(getter, capturedHttpHeaders);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.set(attributes, SemanticAttributes.HTTP_URL, ((HttpClientAttributesGetter)this.getter).url(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.set(attributes, SemanticAttributes.HTTP_FLAVOR, ((HttpClientAttributesGetter)this.getter).flavor(request, response));
    }
}

