/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.config.NamingConvention;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ConfigBuilder {
    private final Map<String, String> allProperties = new HashMap<String, String>();

    @Deprecated
    public ConfigBuilder() {
    }

    public ConfigBuilder addProperty(String name, String value) {
        this.allProperties.put(NamingConvention.DOT.normalize(name), value);
        return this;
    }

    @Deprecated
    public ConfigBuilder readProperties(Properties properties) {
        return this.addProperties(properties);
    }

    @Deprecated
    public ConfigBuilder readProperties(Map<String, String> properties) {
        return this.addProperties(properties);
    }

    public ConfigBuilder addProperties(Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            this.allProperties.put(NamingConvention.DOT.normalize(name), properties.getProperty(name));
        }
        return this;
    }

    public ConfigBuilder addProperties(Map<String, String> properties) {
        return this.fromConfigMap(properties, NamingConvention.DOT);
    }

    @Deprecated
    public ConfigBuilder readEnvironmentVariables() {
        return this.addEnvironmentVariables();
    }

    public ConfigBuilder addEnvironmentVariables() {
        return this.fromConfigMap(System.getenv(), NamingConvention.ENV_VAR);
    }

    @Deprecated
    public ConfigBuilder readSystemProperties() {
        return this.addSystemProperties();
    }

    public ConfigBuilder addSystemProperties() {
        return this.addProperties(System.getProperties());
    }

    private ConfigBuilder fromConfigMap(Map<String, String> configMap, NamingConvention namingConvention) {
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            this.allProperties.put(namingConvention.normalize(entry.getKey()), entry.getValue());
        }
        return this;
    }

    public Config build() {
        return Config.create(Collections.unmodifiableMap(new HashMap<String, String>(this.allProperties)));
    }
}

