/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ClientInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.ServerInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.instrumentation.api.instrumenter.TimeExtractor;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    private static final boolean ENABLE_SPAN_SUPPRESSION_BY_TYPE = Config.get().getBoolean("otel.instrumentation.experimental.outgoing-span-suppression-by-type", false);
    final OpenTelemetry openTelemetry;
    final String instrumentationName;
    final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    final List<SpanLinksExtractor<? super REQUEST>> spanLinksExtractors = new ArrayList<SpanLinksExtractor<? super REQUEST>>();
    final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    final List<ContextCustomizer<? super REQUEST>> contextCustomizers = new ArrayList<ContextCustomizer<? super REQUEST>>();
    private final List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    private final List<RequestMetrics> requestMetrics = new ArrayList<RequestMetrics>();
    @Nullable
    private String instrumentationVersion;
    @Nullable
    private String schemaUrl = null;
    SpanKindExtractor<? super REQUEST> spanKindExtractor = SpanKindExtractor.alwaysInternal();
    SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.jdk();
    @Nullable
    TimeExtractor<REQUEST, RESPONSE> timeExtractor = null;
    boolean enabled = true;
    private boolean enableSpanSuppressionByType = ENABLE_SPAN_SUPPRESSION_BY_TYPE;

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.spanNameExtractor = spanNameExtractor;
        this.instrumentationVersion = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setInstrumentationVersion(String instrumentationVersion) {
        this.instrumentationVersion = instrumentationVersion;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = spanStatusExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(attributesExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this.attributesExtractors::add);
        return this;
    }

    @SafeVarargs
    public final InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(AttributesExtractor<? super REQUEST, ? super RESPONSE> ... attributesExtractors) {
        return this.addAttributesExtractors(Arrays.asList(attributesExtractors));
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addSpanLinksExtractor(SpanLinksExtractor<REQUEST> spanLinksExtractor) {
        this.spanLinksExtractors.add(spanLinksExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addContextCustomizer(ContextCustomizer<? super REQUEST> contextCustomizer) {
        this.contextCustomizers.add(contextCustomizer);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addRequestListener(RequestListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addRequestMetrics(RequestMetrics factory) {
        this.requestMetrics.add(factory);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setTimeExtractor(TimeExtractor<REQUEST, RESPONSE> timeExtractor) {
        this.timeExtractor = Objects.requireNonNull(timeExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Deprecated
    public InstrumenterBuilder<REQUEST, RESPONSE> setDisabled(boolean disabled) {
        return this.setEnabled(!disabled);
    }

    InstrumenterBuilder<REQUEST, RESPONSE> enableInstrumentationTypeSuppression(boolean enableInstrumentationType) {
        this.enableSpanSuppressionByType = enableInstrumentationType;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> newClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> newServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(getter), SpanKindExtractor.alwaysServer());
    }

    public Instrumenter<REQUEST, RESPONSE> newProducerInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<REQUEST, RESPONSE> newConsumerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(getter), SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter() {
        return this.newInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.newInstrumenter(InstrumenterConstructor.internal(), spanKindExtractor);
    }

    private Instrumenter<REQUEST, RESPONSE> newInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        this.spanKindExtractor = spanKindExtractor;
        return constructor.create(this);
    }

    Tracer buildTracer() {
        TracerBuilder tracerBuilder = this.openTelemetry.getTracerProvider().tracerBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            tracerBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if (this.schemaUrl != null) {
            tracerBuilder.setSchemaUrl(this.schemaUrl);
        }
        return tracerBuilder.build();
    }

    List<RequestListener> buildRequestListeners() {
        if (this.requestMetrics.isEmpty()) {
            return new ArrayList<RequestListener>(this.requestListeners);
        }
        ArrayList<RequestListener> listeners = new ArrayList<RequestListener>(this.requestListeners.size() + this.requestMetrics.size());
        listeners.addAll(this.requestListeners);
        MeterBuilder meterBuilder = this.openTelemetry.getMeterProvider().meterBuilder(this.instrumentationName);
        if (this.instrumentationVersion != null) {
            meterBuilder.setInstrumentationVersion(this.instrumentationVersion);
        }
        if (this.schemaUrl != null) {
            meterBuilder.setSchemaUrl(this.schemaUrl);
        }
        Meter meter = meterBuilder.build();
        for (RequestMetrics factory : this.requestMetrics) {
            listeners.add(factory.create(meter));
        }
        return listeners;
    }

    SpanSuppressionStrategy buildSpanSuppressionStrategy() {
        Set<SpanKey> spanKeys = this.getSpanKeysFromAttributesExtractors();
        if (this.enableSpanSuppressionByType) {
            return SpanSuppressionStrategy.from(spanKeys);
        }
        return SpanSuppressionStrategy.suppressNestedClients(spanKeys);
    }

    private Set<SpanKey> getSpanKeysFromAttributesExtractors() {
        return this.attributesExtractors.stream().filter(SpanKeyProvider.class::isInstance).map(SpanKeyProvider.class::cast).flatMap(provider -> {
            SpanKey spanKey = provider.internalGetSpanKey();
            return spanKey == null ? Stream.of(new SpanKey[0]) : Stream.of(spanKey);
        }).collect(Collectors.toSet());
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(InstrumenterBuilder<RQ, RS> var1);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(TextMapSetter<RQ> setter) {
            return builder -> new ClientInstrumenter(builder, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(TextMapGetter<RQ> getter) {
            return builder -> new ServerInstrumenter(builder, getter);
        }
    }
}

