/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.instrumentation.api.instrumenter.TimeExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends OperationListener> operationListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    @Nullable
    private final TimeExtractor<REQUEST, RESPONSE> timeExtractor;
    private final boolean enabled;
    private final SpanSuppressor spanSuppressor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.operationListeners = builder.buildOperationListeners();
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.timeExtractor = builder.timeExtractor;
        this.enabled = builder.enabled;
        this.spanSuppressor = builder.buildSpanSuppressor();
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (!this.enabled) {
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressor.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    /*
     * WARNING - void declaration
     */
    public Context start(Context parentContext, REQUEST request) {
        void var8_17;
        void var8_14;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        Instant startTime = null;
        if (this.timeExtractor != null) {
            startTime = this.timeExtractor.extractStartTime(request);
            spanBuilder.setStartTimestamp(startTime);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributes, parentContext, request);
        }
        Context context = parentContext;
        spanBuilder.setAllAttributes((Attributes)attributes);
        Span span = spanBuilder.startSpan();
        Context context2 = context.with((ImplicitContextKeyed)span);
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            void var8_12;
            Context context3 = contextCustomizer.onStart((Context)var8_12, request, attributes);
        }
        if (!this.operationListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (OperationListener operationListener : this.operationListeners) {
                Context context4 = operationListener.onStart((Context)var8_14, attributes, startNanos);
            }
        }
        if (LocalRootSpan.isLocalRoot(parentContext)) {
            Context context5 = LocalRootSpan.store((Context)var8_14, span);
        }
        return this.spanSuppressor.storeInContext((Context)var8_17, spanKind, span);
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCode;
        Span span = Span.fromContext((Context)context);
        if (error != null) {
            error = this.errorCauseExtractor.extract(error);
            span.recordException(error);
        }
        UnsafeAttributes attributes = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributes, context, request, response, error);
        }
        span.setAllAttributes((Attributes)attributes);
        Instant endTime = null;
        if (this.timeExtractor != null) {
            endTime = this.timeExtractor.extractEndTime(request, response, error);
        }
        if (!this.operationListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            ListIterator<? extends OperationListener> i = this.operationListeners.listIterator(this.operationListeners.size());
            while (i.hasPrevious()) {
                i.previous().onEnd(context, attributes, endNanos);
            }
        }
        if ((statusCode = this.spanStatusExtractor.extract(request, response, error)) != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
        if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }
}

