/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.api.config.AutoValue_Config;
import io.opentelemetry.instrumentation.api.config.ConfigBuilder;
import io.opentelemetry.instrumentation.api.config.ConfigValueParser;
import io.opentelemetry.instrumentation.api.config.ConfigValueParsers;
import io.opentelemetry.instrumentation.api.config.NamingConvention;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoValue
public abstract class Config {
    private static final Logger logger = Logger.getLogger(Config.class.getName());
    @Nullable
    private static volatile Config instance = null;

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    static Config create(Map<String, String> allProperties) {
        return new AutoValue_Config(allProperties);
    }

    Config() {
    }

    public static void internalInitializeConfig(Config config) {
        if (instance != null) {
            logger.warning("Config#INSTANCE was already set earlier");
            return;
        }
        instance = Objects.requireNonNull(config);
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.builder().addEnvironmentVariables().addSystemProperties().build();
        }
        return instance;
    }

    public abstract Map<String, String> getAllProperties();

    @Nullable
    public String getString(String name) {
        return this.getRawProperty(name, null);
    }

    public String getString(String name, String defaultValue) {
        return this.getRawProperty(name, defaultValue);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseBoolean, defaultValue);
    }

    public int getInt(String name, int defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseInt, defaultValue);
    }

    public long getLong(String name, long defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseLong, defaultValue);
    }

    public double getDouble(String name, double defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseDouble, defaultValue);
    }

    public Duration getDuration(String name, Duration defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseDuration, defaultValue);
    }

    public List<String> getList(String name, List<String> defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseList, defaultValue);
    }

    public Map<String, String> getMap(String name, Map<String, String> defaultValue) {
        return this.safeGetTypedProperty(name, ConfigValueParsers::parseMap, defaultValue);
    }

    private <T> T safeGetTypedProperty(String name, ConfigValueParser<T> parser, T defaultValue) {
        try {
            T value = this.getTypedProperty(name, parser);
            return value == null ? defaultValue : value;
        }
        catch (RuntimeException t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Error occurred during parsing: " + t.getMessage(), t);
            }
            return defaultValue;
        }
    }

    @Nullable
    private <T> T getTypedProperty(String name, ConfigValueParser<T> parser) {
        String value = this.getRawProperty(name, null);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return parser.parse(name, value);
    }

    private String getRawProperty(String name, String defaultValue) {
        return this.getAllProperties().getOrDefault(NamingConvention.DOT.normalize(name), defaultValue);
    }

    public ConfigBuilder toBuilder() {
        return new ConfigBuilder(this.getAllProperties());
    }
}

