/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.EndTimeExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinkExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.StartTimeExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.instrumentation.api.tracer.ClientSpan;
import io.opentelemetry.instrumentation.api.tracer.ConsumerSpan;
import io.opentelemetry.instrumentation.api.tracer.ServerSpan;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends SpanLinkExtractor<? super REQUEST>> spanLinkExtractors;
    private final List<? extends RequestListener> requestListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final @Nullable StartTimeExtractor<REQUEST> startTimeExtractor;
    private final @Nullable EndTimeExtractor<RESPONSE> endTimeExtractor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> newBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.openTelemetry.getTracer(this.instrumentationName, InstrumentationVersion.VERSION);
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.spanLinkExtractors = new ArrayList(builder.spanLinkExtractors);
        this.requestListeners = new ArrayList<RequestListener>(builder.requestListeners);
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.startTimeExtractor = builder.startTimeExtractor;
        this.endTimeExtractor = builder.endTimeExtractor;
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        boolean suppressed = false;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        switch (spanKind) {
            case SERVER: 
            case CONSUMER: {
                suppressed = ServerSpan.exists(parentContext) || ConsumerSpan.exists(parentContext);
                break;
            }
            case CLIENT: {
                suppressed = ClientSpan.exists(parentContext);
                break;
            }
        }
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    /*
     * WARNING - void declaration
     */
    public Context start(Context parentContext, REQUEST request) {
        void var7_11;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        if (this.startTimeExtractor != null) {
            spanBuilder.setStartTimestamp(this.startTimeExtractor.extract(request));
        }
        for (SpanLinkExtractor<REQUEST> spanLinkExtractor : this.spanLinkExtractors) {
            spanBuilder.addLink(spanLinkExtractor.extract(parentContext, request));
        }
        UnsafeAttributes attributesBuilder = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributesBuilder, request);
        }
        UnsafeAttributes unsafeAttributes = attributesBuilder;
        Context context = parentContext;
        for (RequestListener requestListener : this.requestListeners) {
            Context context2 = requestListener.start((Context)var7_11, unsafeAttributes);
        }
        spanBuilder.setAllAttributes((Attributes)unsafeAttributes);
        Span span = spanBuilder.startSpan();
        Context context3 = var7_11.with((ImplicitContextKeyed)span);
        switch (spanKind) {
            case SERVER: {
                return ServerSpan.with(context3, span);
            }
            case CLIENT: {
                return ClientSpan.with(context3, span);
            }
            case CONSUMER: {
                return ConsumerSpan.with(context3, span);
            }
        }
        return context3;
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCode;
        Span span = Span.fromContext((Context)context);
        UnsafeAttributes attributesBuilder = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onEnd(attributesBuilder, request, response);
        }
        UnsafeAttributes attributes = attributesBuilder;
        for (RequestListener requestListener : this.requestListeners) {
            requestListener.end(context, attributes);
        }
        span.setAllAttributes((Attributes)attributes);
        if (error != null) {
            error = this.errorCauseExtractor.extractCause(error);
            span.recordException(error);
        }
        if ((statusCode = this.spanStatusExtractor.extract(request, response, error)) != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
        if (this.endTimeExtractor != null) {
            span.end(this.endTimeExtractor.extract(response));
        } else {
            span.end();
        }
    }
}

