/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.api.config.Config;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SupportabilityMetrics {
    private static final Logger logger = LoggerFactory.getLogger(SupportabilityMetrics.class);
    private final boolean agentDebugEnabled;
    private final Consumer<String> reporter;
    private final ConcurrentMap<String, KindCounters> suppressionCounters = new ConcurrentHashMap<String, KindCounters>();
    private final ConcurrentMap<String, LongAdder> counters = new ConcurrentHashMap<String, LongAdder>();
    private static final SupportabilityMetrics INSTANCE = new SupportabilityMetrics(Config.get(), arg_0 -> ((Logger)logger).debug(arg_0)).start();

    public static SupportabilityMetrics instance() {
        return INSTANCE;
    }

    SupportabilityMetrics(Config config, Consumer<String> reporter) {
        this.agentDebugEnabled = config.isAgentDebugEnabled();
        this.reporter = reporter;
    }

    public void recordSuppressedSpan(SpanKind kind, String instrumentationName) {
        if (!this.agentDebugEnabled) {
            return;
        }
        this.suppressionCounters.computeIfAbsent(instrumentationName, s -> new KindCounters()).increment(kind);
    }

    public void incrementCounter(String counterName) {
        if (!this.agentDebugEnabled) {
            return;
        }
        this.counters.computeIfAbsent(counterName, k -> new LongAdder()).increment();
    }

    void report() {
        this.suppressionCounters.forEach((instrumentationName, countsByKind) -> {
            for (SpanKind kind : SpanKind.values()) {
                long value = countsByKind.getAndReset(kind);
                if (value <= 0L) continue;
                this.reporter.accept("Suppressed Spans by '" + instrumentationName + "' (" + kind + ") : " + value);
            }
        });
        this.counters.forEach((counterName, counter) -> {
            long value = counter.sumThenReset();
            if (value > 0L) {
                this.reporter.accept("Counter '" + counterName + "' : " + value);
            }
        });
    }

    SupportabilityMetrics start() {
        if (this.agentDebugEnabled) {
            Executors.newScheduledThreadPool(1, runnable -> {
                Thread result = new Thread(runnable, "supportability_metrics_reporter");
                result.setDaemon(true);
                result.setContextClassLoader(null);
                return result;
            }).scheduleAtFixedRate(this::report, 5L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    private static class KindCounters {
        private final LongAdder server = new LongAdder();
        private final LongAdder client = new LongAdder();
        private final LongAdder internal = new LongAdder();
        private final LongAdder consumer = new LongAdder();
        private final LongAdder producer = new LongAdder();

        private KindCounters() {
        }

        void increment(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    this.internal.increment();
                    break;
                }
                case SERVER: {
                    this.server.increment();
                    break;
                }
                case CLIENT: {
                    this.client.increment();
                    break;
                }
                case PRODUCER: {
                    this.producer.increment();
                    break;
                }
                case CONSUMER: {
                    this.consumer.increment();
                }
            }
        }

        long getAndReset(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    return this.internal.sumThenReset();
                }
                case SERVER: {
                    return this.server.sumThenReset();
                }
                case CLIENT: {
                    return this.client.sumThenReset();
                }
                case PRODUCER: {
                    return this.producer.sumThenReset();
                }
                case CONSUMER: {
                    return this.consumer.sumThenReset();
                }
            }
            return 0L;
        }
    }

    public static final class CounterNames {
        public static final String SQL_STATEMENT_SANITIZER_CACHE_MISS = "SqlStatementSanitizer cache miss";

        private CounterNames() {
        }
    }
}

