/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import org.checkerframework.checker.nullness.qual.Nullable;

public class UriBuilder {
    public static String uri(String scheme, String host, int serverPort, String path, @Nullable String query) {
        boolean isDefaultPort = scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443;
        int length = scheme.length() + 3 + host.length() + path.length();
        if (!isDefaultPort && serverPort != -1) {
            length += 6;
        }
        if (query != null) {
            length += 1 + query.length();
        }
        StringBuilder url = new StringBuilder(length);
        url.append(scheme);
        url.append("://");
        url.append(host);
        if (!isDefaultPort && serverPort != -1) {
            url.append(':');
            url.append(serverPort);
        }
        url.append(path);
        if (query != null) {
            url.append('?');
            url.append(query);
        }
        return url.toString();
    }

    private UriBuilder() {
    }
}

