/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ServerInstrumenter<REQUEST, RESPONSE>
extends Instrumenter<REQUEST, RESPONSE> {
    private final ContextPropagators propagators;
    private final TextMapGetter<REQUEST> getter;

    ServerInstrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder, TextMapGetter<REQUEST> getter) {
        super(ServerInstrumenter.addClientIpExtractor(builder, getter));
        this.propagators = builder.openTelemetry.getPropagators();
        this.getter = getter;
    }

    @Override
    public Context start(Context parentContext, REQUEST request) {
        ContextPropagationDebug.debugContextLeakIfEnabled();
        Context extracted = this.propagators.getTextMapPropagator().extract(parentContext, request, this.getter);
        return super.start(extracted, request);
    }

    private static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> addClientIpExtractor(InstrumenterBuilder<REQUEST, RESPONSE> builder, TextMapGetter<REQUEST> getter) {
        HttpAttributesExtractor httpAttributesExtractor = null;
        for (AttributesExtractor attributesExtractor : builder.attributesExtractors) {
            if (!(attributesExtractor instanceof HttpAttributesExtractor)) continue;
            httpAttributesExtractor = (HttpAttributesExtractor)attributesExtractor;
        }
        if (httpAttributesExtractor == null) {
            return builder;
        }
        builder.addAttributesExtractor(new HttpClientIpExtractor(getter));
        return builder;
    }

    static @Nullable String extractForwarded(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        return ServerInstrumenter.extractIpAddress(forwarded, start);
    }

    static @Nullable String extractForwardedFor(String forwarded) {
        return ServerInstrumenter.extractIpAddress(forwarded, 0);
    }

    private static @Nullable String extractIpAddress(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return ServerInstrumenter.extractIpAddress(forwarded, start + 1);
        }
        if (forwarded.charAt(start) == '[') {
            int end = forwarded.indexOf(93, start + 1);
            if (end == -1) {
                return null;
            }
            return forwarded.substring(start + 1, end);
        }
        boolean inIpv4 = false;
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
                continue;
            }
            if (c != ',' && c != ';' && c != '\"' && (!inIpv4 || c != ':')) continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private static class HttpClientIpExtractor<REQUEST, RESPONSE>
    extends AttributesExtractor<REQUEST, RESPONSE> {
        private final TextMapGetter<REQUEST> getter;

        HttpClientIpExtractor(TextMapGetter<REQUEST> getter) {
            this.getter = getter;
        }

        @Override
        protected void onStart(AttributesBuilder attributes, REQUEST request) {
        }

        @Override
        protected void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
            String clientIp = this.getForwardedClientIp(request);
            HttpClientIpExtractor.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, clientIp);
        }

        @Nullable String getForwardedClientIp(REQUEST request) {
            String forwarded = this.getter.get(request, "Forwarded");
            if (forwarded != null && (forwarded = ServerInstrumenter.extractForwarded(forwarded)) != null) {
                return forwarded;
            }
            forwarded = this.getter.get(request, "X-Forwarded-For");
            if (forwarded != null) {
                return ServerInstrumenter.extractForwardedFor(forwarded);
            }
            return null;
        }
    }
}

