/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.tracer.HttpStatusConverter;
import javax.annotation.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpCommonAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(attributesExtractor);
    }

    private HttpSpanStatusExtractor(HttpCommonAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public StatusCode extract(REQUEST request, @Nullable RESPONSE response, Throwable error) {
        StatusCode statusCodeObj;
        Integer statusCode;
        if (response != null && (statusCode = this.attributesExtractor.statusCode(request, response)) != null && (statusCodeObj = HttpStatusConverter.statusFromHttpStatus(statusCode)) == StatusCode.ERROR) {
            return statusCodeObj;
        }
        return SpanStatusExtractor.getDefault().extract(request, response, error);
    }
}

