/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal.shaded.caffeine3.cache;

import io.opentelemetry.instrumentation.api.internal.shaded.caffeine3.cache.BoundedWeigher;
import io.opentelemetry.instrumentation.api.internal.shaded.caffeine3.cache.SingletonWeigher;
import org.checkerframework.checker.index.qual.NonNegative;

@FunctionalInterface
public interface Weigher<K, V> {
    public @NonNegative int weigh(K var1, V var2);

    public static <K, V> Weigher<K, V> singletonWeigher() {
        SingletonWeigher self = SingletonWeigher.INSTANCE;
        return self;
    }

    public static <K, V> Weigher<K, V> boundedWeigher(Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

