/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer.net;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.tracer.AttributeSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public final class NetPeerAttributes {
    public static final NetPeerAttributes INSTANCE = new NetPeerAttributes(Config.get().getMap("otel.instrumentation.common.peer-service-mapping"));
    private final Map<String, String> peerServiceMapping;

    public NetPeerAttributes() {
        this(Collections.emptyMap());
    }

    public NetPeerAttributes(Map<String, String> peerServiceMapping) {
        this.peerServiceMapping = peerServiceMapping;
    }

    public void setNetPeer(Span span, @Nullable InetSocketAddress remoteConnection) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), remoteConnection);
    }

    public void setNetPeer(SpanBuilder span, @Nullable InetSocketAddress remoteConnection) {
        this.setNetPeer((arg_0, arg_1) -> ((SpanBuilder)span).setAttribute(arg_0, arg_1), remoteConnection);
    }

    public void setNetPeer(AttributeSetter span, @Nullable InetSocketAddress remoteConnection) {
        if (remoteConnection != null) {
            InetAddress remoteAddress = remoteConnection.getAddress();
            if (remoteAddress != null) {
                this.setNetPeer(span, remoteAddress.getHostName(), remoteAddress.getHostAddress(), remoteConnection.getPort());
            } else {
                this.setNetPeer(span, remoteConnection.getHostString(), null, remoteConnection.getPort());
            }
        }
    }

    public void setNetPeer(SpanBuilder span, InetAddress remoteAddress, int port) {
        this.setNetPeer((arg_0, arg_1) -> ((SpanBuilder)span).setAttribute(arg_0, arg_1), remoteAddress.getHostName(), remoteAddress.getHostAddress(), port);
    }

    public void setNetPeer(Span span, String peerName, String peerIp) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, -1);
    }

    public void setNetPeer(Span span, String peerName, String peerIp, int port) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, port);
    }

    public void setNetPeer(AttributeSetter span, @Nullable String peerName, @Nullable String peerIp, int port) {
        String peerService;
        if (peerName != null && !peerName.equals(peerIp)) {
            span.setAttribute(SemanticAttributes.NET_PEER_NAME, peerName);
        }
        if (peerIp != null) {
            span.setAttribute(SemanticAttributes.NET_PEER_IP, peerIp);
        }
        if ((peerService = this.mapToPeerService(peerName)) == null) {
            peerService = this.mapToPeerService(peerIp);
        }
        if (peerService != null) {
            span.setAttribute(SemanticAttributes.PEER_SERVICE, peerService);
        }
        if (port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, Long.valueOf(port));
        }
    }

    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

